/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.providers.FileRange;
import org.jboss.resteasy.util.MediaTypeHelper;

@Provider
@Produces(value={"*/*"})
public class FileRangeWriter
implements MessageBodyWriter<FileRange> {
    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(FileRange.class) && !MediaTypeHelper.isBlacklisted(mediaType);
    }

    @Override
    public long getSize(FileRange fileRange, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(FileRange fileRange, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        long fileSize = fileRange.getFile().length();
        String contentRange = "bytes " + fileRange.getBegin() + "-" + fileRange.getEnd() + "/" + fileSize;
        long length = fileRange.getEnd() - fileRange.getBegin() + 1L;
        httpHeaders.putSingle("Content-Range", contentRange);
        httpHeaders.putSingle("Content-Length", length);
        try (FileInputStream fis = new FileInputStream(fileRange.getFile());){
            if (fileRange.getBegin() > 0L) {
                fis.getChannel().position(fileRange.getBegin());
            }
            byte[] buf = new byte[2048];
            while (length > 0L) {
                int len = 2048L > length ? (int)length : 2048;
                int read = fis.read(buf, 0, len);
                if (read == -1) {
                    break;
                }
                entityStream.write(buf, 0, read);
                length -= (long)len;
            }
        }
    }
}

