/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.core.interception.ContainerResponseContextImpl;
import org.jboss.resteasy.core.interception.JaxrsInterceptorRegistry;
import org.jboss.resteasy.core.interception.LegacyPrecedence;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.PostProcessInterceptor;

public class ContainerResponseFilterRegistry
extends JaxrsInterceptorRegistry<ContainerResponseFilter> {
    protected LegacyPrecedence precedence;

    public ContainerResponseFilterRegistry(ResteasyProviderFactory providerFactory, LegacyPrecedence precedence) {
        super(providerFactory, ContainerResponseFilter.class);
        this.precedence = precedence;
    }

    @Override
    protected void sort(List<JaxrsInterceptorRegistry.Match> matches) {
        Collections.sort(matches, new JaxrsInterceptorRegistry.DescendingPrecedenceComparator());
    }

    public ContainerResponseFilterRegistry clone(ResteasyProviderFactory factory) {
        ContainerResponseFilterRegistry clone = new ContainerResponseFilterRegistry(factory, this.precedence);
        clone.interceptors.addAll(this.interceptors);
        return clone;
    }

    @Override
    public synchronized void registerClass(Class<? extends ContainerResponseFilter> declaring) {
        JaxrsInterceptorRegistry.OnDemandInterceptorFactory factory = new JaxrsInterceptorRegistry.OnDemandInterceptorFactory(this, declaring);
        factory.setIgnorePrematch(true);
        this.register(factory);
    }

    @Override
    public synchronized void registerClass(Class<? extends ContainerResponseFilter> declaring, int priority) {
        JaxrsInterceptorRegistry.OnDemandInterceptorFactory factory = new JaxrsInterceptorRegistry.OnDemandInterceptorFactory(this, declaring);
        factory.setIgnorePrematch(true);
        factory.setOrder(priority);
        this.register(factory);
    }

    @Override
    public synchronized void registerSingleton(ContainerResponseFilter interceptor) {
        JaxrsInterceptorRegistry.SingletonInterceptorFactory factory = new JaxrsInterceptorRegistry.SingletonInterceptorFactory(this, interceptor.getClass(), interceptor);
        factory.setIgnorePrematch(true);
        this.register(factory);
    }

    @Override
    public synchronized void registerSingleton(ContainerResponseFilter interceptor, int priority) {
        JaxrsInterceptorRegistry.SingletonInterceptorFactory factory = new JaxrsInterceptorRegistry.SingletonInterceptorFactory(this, interceptor.getClass(), interceptor);
        factory.setIgnorePrematch(true);
        factory.setOrder(priority);
        this.register(factory);
    }

    public void registerLegacy(Class<? extends PostProcessInterceptor> decl) {
        this.register(new JaxrsInterceptorRegistry.LegacyPerMethodInterceptorFactory(decl, this.precedence){

            @Override
            public JaxrsInterceptorRegistry.Match postMatch(Class declaring, AccessibleObject target) {
                Object obj = this.getLegacyMatch(declaring, target);
                if (obj == null) {
                    return null;
                }
                PostProcessInterceptor interceptor = (PostProcessInterceptor)obj;
                return new JaxrsInterceptorRegistry.Match(new ContainerResponseFilterFacade(interceptor), this.order);
            }
        });
    }

    public void registerLegacy(PostProcessInterceptor interceptor) {
        this.register(new JaxrsInterceptorRegistry.LegacySingletonInterceptorFactory(interceptor.getClass(), (Object)interceptor, this.precedence){

            @Override
            public JaxrsInterceptorRegistry.Match postMatch(Class declaring, AccessibleObject target) {
                Object obj = this.getLegacyMatch(declaring, target);
                if (obj == null) {
                    return null;
                }
                PostProcessInterceptor interceptor = (PostProcessInterceptor)obj;
                return new JaxrsInterceptorRegistry.Match(new ContainerResponseFilterFacade(interceptor), this.order);
            }
        });
    }

    private static class ContainerResponseFilterFacade
    implements ContainerResponseFilter {
        protected final PostProcessInterceptor interceptor;

        private ContainerResponseFilterFacade(PostProcessInterceptor interceptor) {
            this.interceptor = interceptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            ContainerResponseContextImpl ctx = (ContainerResponseContextImpl)responseContext;
            BuiltResponse jaxrsResposne = ctx.getJaxrsResponse();
            ServerResponse serverResponse = new ServerResponse(jaxrsResposne);
            try {
                this.interceptor.postProcess(serverResponse);
            }
            finally {
                jaxrsResposne.setStatus(serverResponse.getStatus());
                jaxrsResposne.setAnnotations(serverResponse.getAnnotations());
                jaxrsResposne.setEntity(serverResponse.getEntity());
                jaxrsResposne.setMetadata(serverResponse.getMetadata());
                jaxrsResposne.setEntityClass(serverResponse.getEntityClass());
                jaxrsResposne.setGenericType(serverResponse.getGenericType());
            }
        }
    }
}

