/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.SecurityContext;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.server.servlet.ConfigurationBootstrap;
import org.jboss.resteasy.plugins.server.servlet.HttpRequestFactory;
import org.jboss.resteasy.plugins.server.servlet.HttpResponseFactory;
import org.jboss.resteasy.plugins.server.servlet.ServletSecurityContext;
import org.jboss.resteasy.plugins.server.servlet.ServletUtil;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.jboss.resteasy.util.GetRestful;

public class ServletContainerDispatcher {
    protected Dispatcher dispatcher;
    protected ResteasyProviderFactory providerFactory;
    private String servletMappingPrefix = "";
    protected ResteasyDeployment deployment = null;
    protected HttpRequestFactory requestFactory;
    protected HttpResponseFactory responseFactory;
    protected ServletConfig servletConfig;

    public ServletContainerDispatcher(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
        ResteasyProviderFactory.pushContext(ServletConfig.class, servletConfig);
    }

    public ServletContainerDispatcher() {
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletContext servletContext, ConfigurationBootstrap bootstrap, HttpRequestFactory requestFactory, HttpResponseFactory responseFactory) throws ServletException {
        boolean useGlobal;
        Dispatcher globalDispatcher;
        this.requestFactory = requestFactory;
        this.responseFactory = responseFactory;
        ResteasyDeployment ctxDeployment = (ResteasyDeployment)servletContext.getAttribute(ResteasyDeployment.class.getName());
        ResteasyProviderFactory globalFactory = (ResteasyProviderFactory)servletContext.getAttribute(ResteasyProviderFactory.class.getName());
        if (globalFactory == null && ctxDeployment != null) {
            globalFactory = ctxDeployment.getProviderFactory();
        }
        if ((globalDispatcher = (Dispatcher)servletContext.getAttribute(Dispatcher.class.getName())) == null && ctxDeployment != null) {
            globalDispatcher = ctxDeployment.getDispatcher();
        }
        String application = bootstrap.getInitParameter("javax.ws.rs.Application");
        String useGlobalStr = bootstrap.getInitParameter("resteasy.servlet.context.deployment");
        boolean bl = useGlobal = globalFactory != null;
        if (useGlobalStr != null) {
            useGlobal = Boolean.parseBoolean(useGlobalStr);
        }
        if (useGlobal) {
            this.providerFactory = globalFactory;
            this.dispatcher = globalDispatcher;
            if (this.providerFactory != null && this.dispatcher == null || this.providerFactory == null && this.dispatcher != null) {
                throw new ServletException(Messages.MESSAGES.unknownStateListener());
            }
            if (this.providerFactory == null) {
                this.deployment = bootstrap.createDeployment();
                this.deployment.start();
                servletContext.setAttribute(ResteasyProviderFactory.class.getName(), (Object)this.deployment.getProviderFactory());
                servletContext.setAttribute(Dispatcher.class.getName(), (Object)this.deployment.getDispatcher());
                servletContext.setAttribute(Registry.class.getName(), (Object)this.deployment.getRegistry());
                this.dispatcher = this.deployment.getDispatcher();
                this.providerFactory = this.deployment.getProviderFactory();
            } else if (application != null) {
                try {
                    Map<Class<?>, Object> contextDataMap = ResteasyProviderFactory.getContextDataMap();
                    contextDataMap.putAll(this.dispatcher.getDefaultContextObjects());
                    Application app = ResteasyDeployment.createApplication(application.trim(), this.dispatcher, this.providerFactory);
                    this.processApplication(app);
                    this.servletMappingPrefix = bootstrap.getParameter("resteasy.servlet.mapping.prefix");
                    if (this.servletMappingPrefix == null) {
                        this.servletMappingPrefix = "";
                    }
                    this.servletMappingPrefix = this.servletMappingPrefix.trim();
                }
                finally {
                    ResteasyProviderFactory.removeContextDataLevel();
                }
            } else {
                this.servletMappingPrefix = bootstrap.getParameter("resteasy.servlet.mapping.prefix");
                if (this.servletMappingPrefix == null) {
                    this.servletMappingPrefix = "";
                }
                this.servletMappingPrefix = this.servletMappingPrefix.trim();
            }
        } else {
            this.servletMappingPrefix = bootstrap.getParameter("resteasy.servlet.mapping.prefix");
            if (this.servletMappingPrefix == null) {
                this.servletMappingPrefix = "";
            }
            this.servletMappingPrefix = this.servletMappingPrefix.trim();
            this.deployment = bootstrap.createDeployment();
            this.deployment.start();
            this.dispatcher = this.deployment.getDispatcher();
            this.providerFactory = this.deployment.getProviderFactory();
        }
    }

    public void destroy() {
        if (this.deployment != null) {
            this.deployment.stop();
        }
    }

    protected void processApplication(Application config) {
        LogMessages.LOGGER.deployingApplication(Application.class.getName(), config.getClass());
        ArrayList<Class> actualResourceClasses = new ArrayList<Class>();
        ArrayList<Class> actualProviderClasses = new ArrayList<Class>();
        ArrayList<Object> resources = new ArrayList<Object>();
        ArrayList<Object> providers = new ArrayList<Object>();
        if (config.getClasses() != null) {
            for (Class clazz : config.getClasses()) {
                if (GetRestful.isRootResource(clazz)) {
                    LogMessages.LOGGER.addingClassResource(clazz.getName(), config.getClass());
                    actualResourceClasses.add(clazz);
                    continue;
                }
                LogMessages.LOGGER.addingProviderClass(clazz.getName(), config.getClass());
                actualProviderClasses.add(clazz);
            }
        }
        if (config.getSingletons() != null) {
            for (Object object : config.getSingletons()) {
                if (GetRestful.isRootResource(object.getClass())) {
                    LogMessages.LOGGER.addingSingletonResource(object.getClass().getName(), config.getClass());
                    resources.add(object);
                    continue;
                }
                LogMessages.LOGGER.addingSingletonProvider(object.getClass().getName(), config.getClass());
                providers.add(object);
            }
        }
        for (Class clazz : actualProviderClasses) {
            this.providerFactory.registerProvider(clazz);
        }
        for (Object object : providers) {
            this.providerFactory.registerProviderInstance(object);
        }
        for (Class clazz : actualResourceClasses) {
            this.dispatcher.getRegistry().addPerRequestResource(clazz);
        }
        for (Object object : resources) {
            this.dispatcher.getRegistry().addSingletonResource(object);
        }
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(String httpMethod, HttpServletRequest request, HttpServletResponse response, boolean handleNotFound) throws IOException, NotFoundException {
        try {
            ResteasyProviderFactory defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.push(this.providerFactory);
            }
            ResteasyHttpHeaders headers = null;
            ResteasyUriInfo uriInfo = null;
            try {
                headers = ServletUtil.extractHttpHeaders(request);
                uriInfo = ServletUtil.extractUriInfo(request, this.servletMappingPrefix);
            }
            catch (Exception e) {
                response.sendError(400);
                LogMessages.LOGGER.failedToParseRequest(e);
                ResteasyProviderFactory defaultInstance2 = ResteasyProviderFactory.getInstance();
                if (defaultInstance2 instanceof ThreadLocalResteasyProviderFactory) {
                    ThreadLocalResteasyProviderFactory.pop();
                }
                return;
            }
            HttpResponse theResponse = this.responseFactory.createResteasyHttpResponse(response);
            HttpRequest in = this.requestFactory.createResteasyHttpRequest(httpMethod, request, headers, uriInfo, theResponse, response);
            try {
                ResteasyProviderFactory.pushContext(HttpServletRequest.class, request);
                ResteasyProviderFactory.pushContext(HttpServletResponse.class, response);
                ResteasyProviderFactory.pushContext(SecurityContext.class, new ServletSecurityContext(request));
                this.dispatcher.getDefaultContextObjects().put(ServletConfig.class, this.servletConfig);
                if (handleNotFound) {
                    this.dispatcher.invoke(in, theResponse);
                } else {
                    ((SynchronousDispatcher)this.dispatcher).invokePropagateNotFound(in, theResponse);
                }
            }
            finally {
                ResteasyProviderFactory.clearContextData();
            }
        }
        finally {
            ResteasyProviderFactory defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.pop();
            }
        }
    }
}

