/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.examples.authenticator;

import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.credential.CredentialTypeMetadataContext;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.examples.authenticator.credential.SecretQuestionCredentialModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;

public class SecretQuestionCredentialProvider
implements CredentialProvider<SecretQuestionCredentialModel>,
CredentialInputValidator {
    private static final Logger logger = Logger.getLogger(SecretQuestionCredentialProvider.class);
    protected KeycloakSession session;

    public SecretQuestionCredentialProvider(KeycloakSession session) {
        this.session = session;
    }

    private UserCredentialStore getCredentialStore() {
        return this.session.userCredentialManager();
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel)) {
            logger.debug((Object)"Expected instance of UserCredentialModel for CredentialInput");
            return false;
        }
        if (!input.getType().equals(this.getType())) {
            return false;
        }
        String challengeResponse = input.getChallengeResponse();
        if (challengeResponse == null) {
            return false;
        }
        CredentialModel credentialModel = this.getCredentialStore().getStoredCredentialById(realm, user, input.getCredentialId());
        SecretQuestionCredentialModel sqcm = this.getCredentialFromModel(credentialModel);
        return sqcm.getSecretQuestionSecretData().getAnswer().equals(challengeResponse);
    }

    public boolean supportsCredentialType(String credentialType) {
        return this.getType().equals(credentialType);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        if (!this.supportsCredentialType(credentialType)) {
            return false;
        }
        return this.getCredentialStore().getStoredCredentialsByTypeStream(realm, user, credentialType).count() > 0L;
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, SecretQuestionCredentialModel credentialModel) {
        if (credentialModel.getCreatedDate() == null) {
            credentialModel.setCreatedDate(Time.currentTimeMillis());
        }
        return this.getCredentialStore().createCredential(realm, user, (CredentialModel)credentialModel);
    }

    public boolean deleteCredential(RealmModel realm, UserModel user, String credentialId) {
        return this.getCredentialStore().removeStoredCredential(realm, user, credentialId);
    }

    public SecretQuestionCredentialModel getCredentialFromModel(CredentialModel model) {
        return SecretQuestionCredentialModel.createFromCredentialModel(model);
    }

    public CredentialTypeMetadata getCredentialTypeMetadata(CredentialTypeMetadataContext metadataContext) {
        return CredentialTypeMetadata.builder().type(this.getType()).category(CredentialTypeMetadata.Category.TWO_FACTOR).displayName("secret-question").helpText("secret-question-text").createAction("secret-question-authenticator").removeable(false).build(this.session);
    }

    public String getType() {
        return "SECRET_QUESTION";
    }
}

