/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.examples.authenticator;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpResponse;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.CredentialValidator;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.common.util.ServerCookie;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.examples.authenticator.SecretQuestionCredentialProvider;
import org.keycloak.examples.authenticator.SecretQuestionRequiredActionFactory;
import org.keycloak.examples.authenticator.credential.SecretQuestionCredentialModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;

public class SecretQuestionAuthenticator
implements Authenticator,
CredentialValidator<SecretQuestionCredentialProvider> {
    protected boolean hasCookie(AuthenticationFlowContext context) {
        boolean result;
        Cookie cookie = (Cookie)context.getHttpRequest().getHttpHeaders().getCookies().get("SECRET_QUESTION_ANSWERED");
        boolean bl = result = cookie != null;
        if (result) {
            System.out.println("Bypassing secret question because cookie is set");
        }
        return result;
    }

    public void authenticate(AuthenticationFlowContext context) {
        if (this.hasCookie(context)) {
            context.success();
            return;
        }
        Response challenge = context.form().createForm("secret-question.ftl");
        context.challenge(challenge);
    }

    public void action(AuthenticationFlowContext context) {
        boolean validated = this.validateAnswer(context);
        if (!validated) {
            Response challenge = context.form().setError("badSecret", new Object[0]).createForm("secret-question.ftl");
            context.failureChallenge(AuthenticationFlowError.INVALID_CREDENTIALS, challenge);
            return;
        }
        this.setCookie(context);
        context.success();
    }

    protected void setCookie(AuthenticationFlowContext context) {
        AuthenticatorConfigModel config = context.getAuthenticatorConfig();
        int maxCookieAge = 2592000;
        if (config != null) {
            maxCookieAge = Integer.valueOf((String)config.getConfig().get("cookie.max.age"));
        }
        URI uri = context.getUriInfo().getBaseUriBuilder().path("realms").path(context.getRealm().getName()).build(new Object[0]);
        this.addCookie(context, "SECRET_QUESTION_ANSWERED", "true", uri.getRawPath(), null, null, maxCookieAge, false, true);
    }

    public void addCookie(AuthenticationFlowContext context, String name, String value, String path, String domain, String comment, int maxAge, boolean secure, boolean httpOnly) {
        HttpResponse response = (HttpResponse)context.getSession().getContext().getContextObject(HttpResponse.class);
        StringBuffer cookieBuf = new StringBuffer();
        ServerCookie.appendCookieValue((StringBuffer)cookieBuf, (int)1, (String)name, (String)value, (String)path, (String)domain, (String)comment, (int)maxAge, (boolean)secure, (boolean)httpOnly, null);
        String cookie = cookieBuf.toString();
        response.getOutputHeaders().add((Object)"Set-Cookie", (Object)cookie);
    }

    protected boolean validateAnswer(AuthenticationFlowContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String secret = (String)formData.getFirst((Object)"secret_answer");
        String credentialId = (String)formData.getFirst((Object)"credentialId");
        if (credentialId == null || credentialId.isEmpty()) {
            credentialId = ((SecretQuestionCredentialModel)this.getCredentialProvider(context.getSession()).getDefaultCredential(context.getSession(), context.getRealm(), context.getUser())).getId();
        }
        UserCredentialModel input = new UserCredentialModel(credentialId, this.getType(context.getSession()), secret);
        return this.getCredentialProvider(context.getSession()).isValid(context.getRealm(), context.getUser(), (CredentialInput)input);
    }

    public boolean requiresUser() {
        return true;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return this.getCredentialProvider(session).isConfiguredFor(realm, user, this.getType(session));
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
        user.addRequiredAction("secret_question_config");
    }

    public List<RequiredActionFactory> getRequiredActions(KeycloakSession session) {
        return Collections.singletonList((SecretQuestionRequiredActionFactory)session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, "secret_question_config"));
    }

    public void close() {
    }

    public SecretQuestionCredentialProvider getCredentialProvider(KeycloakSession session) {
        return (SecretQuestionCredentialProvider)session.getProvider(CredentialProvider.class, "secret-question");
    }
}

