/*
 * Decompiled with CFR 0.152.
 */
package org.kmf.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.Visibility;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaEnumSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.kevoree.modeling.ast.KClass;
import org.kevoree.modeling.ast.KClassifier;
import org.kevoree.modeling.ast.KEnum;
import org.kevoree.modeling.ast.KIndex;
import org.kevoree.modeling.ast.KModel;
import org.kevoree.modeling.ast.KProperty;
import org.kevoree.modeling.ast.KRelation;
import org.kevoree.modeling.ast.ModelBuilder;
import org.kevoree.modeling.ast.impl.Model;
import org.mwg.Graph;
import org.mwg.GraphBuilder;

public class Generator {
    public static String extension = ".mm";
    private KModel model = new Model();
    private List<JavaSource> sources;

    public void scan(File target) throws Exception {
        String[] everythingInThisDir;
        for (String name : everythingInThisDir = target.list()) {
            if (!name.trim().endsWith(extension)) continue;
            ModelBuilder.parse((File)new File(target, name), (KModel)this.model);
        }
    }

    public void deepScan(File target) throws Exception {
        String[] everythingInThisDir;
        for (String name : everythingInThisDir = target.list()) {
            if (name.trim().endsWith(extension)) {
                ModelBuilder.parse((File)new File(target, name), (KModel)this.model);
                continue;
            }
            File current = new File(target, name);
            if (!current.isDirectory()) continue;
            this.deepScan(current);
        }
    }

    public void generate(String name, File target) {
        boolean useML = false;
        this.sources = new ArrayList<JavaSource>();
        for (KClassifier kClassifier : this.model.classifiers()) {
            if (kClassifier instanceof KEnum) {
                KEnum loopEnum = (KEnum)kClassifier;
                JavaEnumSource javaEnum = (JavaEnumSource)Roaster.create(JavaEnumSource.class);
                if (kClassifier.pack() != null) {
                    javaEnum.setPackage(kClassifier.pack());
                }
                javaEnum.setName(kClassifier.name());
                for (String literal : loopEnum.literals()) {
                    javaEnum.addEnumConstant(literal);
                }
                this.sources.add((JavaSource)javaEnum);
                continue;
            }
            if (!(kClassifier instanceof KClass)) continue;
            JavaClassSource javaClass = (JavaClassSource)((JavaClassSource)Roaster.create(JavaClassSource.class)).setFinal(true);
            KClass loopClass = (KClass)kClassifier;
            if (kClassifier.pack() != null) {
                javaClass.setPackage(kClassifier.pack());
            }
            javaClass.setName(kClassifier.name());
            String parentName = "org.mwg.plugin.AbstractNode";
            if (loopClass.parent() != null) {
                parentName = loopClass.parent().fqn();
            }
            javaClass.setSuperType(parentName);
            MethodSource constructor = javaClass.addMethod().setConstructor(true);
            constructor.addParameter("long", "p_world");
            constructor.addParameter("long", "p_time");
            constructor.addParameter("long", "p_id");
            constructor.addParameter(Graph.class, "p_graph");
            constructor.addParameter("long[]", "currentResolution");
            constructor.setBody("super(p_world, p_time, p_id, p_graph, currentResolution);");
            constructor.setVisibility(Visibility.PUBLIC);
            ((FieldSource)((FieldSource)((FieldSource)javaClass.addField().setVisibility(Visibility.PUBLIC)).setFinal(true)).setName("NODE_NAME")).setType(String.class).setStringInitializer(javaClass.getCanonicalName()).setStatic(true);
            for (KProperty prop : loopClass.properties()) {
                StringBuffer buffer;
                MethodSource setter;
                MethodSource getter;
                ((FieldSource)((FieldSource)((FieldSource)javaClass.addField().setVisibility(Visibility.PUBLIC)).setFinal(true)).setName(prop.name().toUpperCase())).setType(String.class).setStringInitializer(prop.name()).setStatic(true);
                if (prop.derived() || prop.learned()) continue;
                if (prop instanceof KRelation) {
                    getter = javaClass.addMethod();
                    ((MethodSource)getter.setVisibility(Visibility.PUBLIC)).setFinal(true);
                    getter.setReturnType(Generator.typeToClassName(prop.type()) + "[]");
                    getter.setName(this.toCamelCase("get " + prop.name()));
                    getter.setBody("org.mwg.DeferCounter waiter = this.graph().newCounter(1);\nthis.rel(" + prop.name().toUpperCase() + ", waiter.wrap());\n" + "org.mwg.Node[] raw = (org.mwg.Node[]) waiter.waitResult();" + Generator.typeToClassName(prop.type()) + "[] casted = new " + Generator.typeToClassName(prop.type()) + "[raw.length];" + "System.arraycopy(raw,0,casted,0,raw.length);\n" + "return casted;");
                    MethodSource add = javaClass.addMethod();
                    ((MethodSource)add.setVisibility(Visibility.PUBLIC)).setFinal(true);
                    add.setName(this.toCamelCase("addTo " + prop.name()));
                    add.setReturnType(kClassifier.fqn());
                    add.addParameter(Generator.typeToClassName(prop.type()), "value");
                    add.setBody("super.add(" + prop.name().toUpperCase() + ",(org.mwg.Node)value);return this;");
                    MethodSource remove = javaClass.addMethod();
                    ((MethodSource)remove.setVisibility(Visibility.PUBLIC)).setFinal(true);
                    remove.setName(this.toCamelCase("removeFrom " + prop.name()));
                    remove.setReturnType(kClassifier.fqn());
                    remove.addParameter(Generator.typeToClassName(prop.type()), "value");
                    remove.setBody("super.remove(" + prop.name().toUpperCase() + ",(org.mwg.Node)value);return this;");
                    continue;
                }
                if (prop.algorithm() != null) {
                    useML = true;
                    getter = javaClass.addMethod();
                    ((MethodSource)getter.setVisibility(Visibility.PUBLIC)).setFinal(true);
                    getter.setReturnType(Generator.typeToClassName(prop.type()));
                    getter.setName(this.toCamelCase("get " + prop.name()));
                    getter.setBody("\t\tfinal org.mwg.DeferCounter waiter = this.graph().newCounter(1);\nthis.rel(" + prop.name().toUpperCase() + ", new org.mwg.Callback<org.mwg.Node[]>() {\n" + "@Override\n" + "public void on(org.mwg.Node[] raw) {\n" + "if (raw == null || raw.length == 0) {\n" + "waiter.count();\n" + "} else {\n" + "org.mwg.ml.RegressionNode casted = (org.mwg.ml.RegressionNode) raw[0];\n" + "casted.extrapolate(waiter.wrap());\n" + "}\n" + "}\n" + "});\n" + "return (" + Generator.typeToClassName(prop.type()) + ") waiter.waitResult();");
                    setter = javaClass.addMethod();
                    ((MethodSource)setter.setVisibility(Visibility.PUBLIC)).setFinal(true);
                    setter.setName(this.toCamelCase("set " + prop.name()));
                    setter.setReturnType(kClassifier.fqn());
                    setter.addParameter(Generator.typeToClassName(prop.type()), "value");
                    buffer = new StringBuffer();
                    buffer.append(" final org.mwg.DeferCounter waiter = this.graph().newCounter(1);\n        final " + kClassifier.fqn() + " selfPointer = this;\n" + "        this.rel(" + prop.name().toUpperCase() + ", new org.mwg.Callback<org.mwg.Node[]>() {\n" + "            @Override\n" + "            public void on(org.mwg.Node[] raw) {\n" + "                if (raw == null || raw.length == 0) {\n" + "                    org.mwg.ml.RegressionNode casted = (org.mwg.ml.RegressionNode) graph().newTypedNode(world(),time(),\"" + prop.algorithm() + "\");\n" + "                    selfPointer.add(" + prop.name().toUpperCase() + ",casted);\n");
                    for (String key : prop.parameters().keySet()) {
                        buffer.append("casted.set(\"" + key + "\"," + (String)prop.parameters().get(key) + ");\n");
                    }
                    buffer.append("                 casted.learn(value, waiter.wrap());\n                } else {\n                    org.mwg.ml.RegressionNode casted = (org.mwg.ml.RegressionNode) raw[0];\n                    casted.learn(value, waiter.wrap());\n                }\n            }\n        });\n        waiter.waitResult();\n        return this;");
                    setter.setBody(buffer.toString());
                    continue;
                }
                getter = javaClass.addMethod();
                ((MethodSource)getter.setVisibility(Visibility.PUBLIC)).setFinal(true);
                getter.setReturnType(Generator.typeToClassName(prop.type()));
                getter.setName(this.toCamelCase("get " + prop.name()));
                getter.setBody("return (" + Generator.typeToClassName(prop.type()) + ") super.get(" + prop.name().toUpperCase() + ");");
                setter = javaClass.addMethod();
                ((MethodSource)setter.setVisibility(Visibility.PUBLIC)).setFinal(true);
                setter.setName(this.toCamelCase("set " + prop.name()));
                setter.setReturnType(kClassifier.fqn());
                setter.addParameter(Generator.typeToClassName(prop.type()), "value");
                buffer = new StringBuffer();
                if (prop.indexes().length > 0) {
                    String queryParam;
                    buffer.append("final " + kClassifier.fqn() + " self = this;\n");
                    buffer.append("final org.mwg.DeferCounter waiterUnIndex = this.graph().newCounter(" + prop.indexes().length + ");\n");
                    buffer.append("final org.mwg.DeferCounter waiterIndex = this.graph().newCounter(" + prop.indexes().length + ");\n");
                    for (Object index : prop.indexes()) {
                        queryParam = "";
                        for (KProperty loopP : index.properties()) {
                            if (!queryParam.isEmpty()) {
                                queryParam = queryParam + ",";
                            }
                            queryParam = queryParam + loopP.name();
                        }
                        buffer.append("this.graph().unindex(\"" + index.fqn() + "\",this,\"" + queryParam + "\",waiterUnIndex.wrap());");
                    }
                    buffer.append("waiterUnIndex.then(new org.mwg.plugin.Job() {");
                    buffer.append("@Override\n");
                    buffer.append("public void run() {\n");
                    buffer.append("self.setProperty(" + prop.name().toUpperCase() + ", (byte) " + Generator.nameToType(prop.type()) + ", value);");
                    for (Object index : prop.indexes()) {
                        queryParam = "";
                        for (KProperty loopP : index.properties()) {
                            if (!queryParam.isEmpty()) {
                                queryParam = queryParam + ",";
                            }
                            queryParam = queryParam + loopP.name();
                        }
                        buffer.append("self.graph().index(\"" + index.fqn() + "\",self,\"" + queryParam + "\",waiterIndex.wrap());");
                    }
                    buffer.append("}\n});");
                    buffer.append("waiterIndex.waitResult();\n");
                } else {
                    buffer.append("super.setProperty(" + prop.name().toUpperCase() + ", (byte)" + Generator.nameToType(prop.type()) + ",value);");
                }
                buffer.append("return this;");
                setter.setBody(buffer.toString());
            }
            this.sources.add((JavaSource)javaClass);
        }
        JavaClassSource pluginClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
        if (name.contains(".")) {
            pluginClass.setPackage(name.substring(0, name.lastIndexOf(46)));
            pluginClass.setName(name.substring(name.lastIndexOf(46) + 1) + "Plugin");
        } else {
            pluginClass.setName(name + "Plugin");
        }
        pluginClass.setSuperType("org.mwg.plugin.AbstractPlugin");
        MethodSource pluginConstructor = pluginClass.addMethod().setConstructor(true);
        StringBuilder constructorContent = new StringBuilder();
        constructorContent.append("super();\n");
        for (KClassifier classifier : this.model.classifiers()) {
            if (!(classifier instanceof KClass)) continue;
            String fqn = classifier.fqn();
            constructorContent.append("\t\tdeclareNodeType(" + fqn + ".NODE_NAME, new org.mwg.plugin.NodeFactory() {\n" + "\t\t\t@Override\n" + "\t\t\tpublic org.mwg.Node create(long world, long time, long id, org.mwg.Graph graph, long[] initialResolution) {\n" + "\t\t\t\treturn (org.mwg.Node)new " + fqn + "(world,time,id,graph,initialResolution);\n" + "\t\t\t}\n" + "\t\t});");
        }
        pluginConstructor.setBody(constructorContent.toString());
        this.sources.add((JavaSource)pluginClass);
        JavaClassSource javaClassSource = (JavaClassSource)Roaster.create(JavaClassSource.class);
        if (name.contains(".")) {
            javaClassSource.setPackage(name.substring(0, name.lastIndexOf(46)));
            javaClassSource.setName(name.substring(name.lastIndexOf(46) + 1) + "Model");
        } else {
            javaClassSource.setName(name + "Model");
        }
        ((FieldSource)((FieldSource)javaClassSource.addField().setName("_graph")).setVisibility(Visibility.PRIVATE)).setType(Graph.class).setFinal(true);
        MethodSource modelConstructor = javaClassSource.addMethod().setConstructor(true);
        modelConstructor.addParameter(GraphBuilder.class, "builder");
        if (useML) {
            modelConstructor.setBody("this._graph = builder.withPlugin(new org.mwg.ml.MLPlugin()).withPlugin(new samplePlugin()).build();");
        } else {
            modelConstructor.setBody("this._graph = builder.withPlugin(new samplePlugin()).build();");
        }
        ((MethodSource)((MethodSource)((MethodSource)javaClassSource.addMethod().setName("graph")).setBody("return this._graph;").setVisibility(Visibility.PUBLIC)).setFinal(true)).setReturnType(Graph.class);
        for (KClassifier classifier : this.model.classifiers()) {
            if (classifier instanceof KClass) {
                MethodSource loopNewMethod = (MethodSource)javaClassSource.addMethod().setName(this.toCamelCase("new " + classifier.name()));
                ((MethodSource)loopNewMethod.setVisibility(Visibility.PUBLIC)).setFinal(true);
                loopNewMethod.setReturnType(classifier.fqn());
                loopNewMethod.addParameter("long", "world");
                loopNewMethod.addParameter("long", "time");
                loopNewMethod.setBody("return (" + classifier.fqn() + ")this._graph.newTypedNode(world,time," + classifier.fqn() + ".NODE_NAME);");
            }
            if (!(classifier instanceof KIndex)) continue;
            KIndex casted = (KIndex)classifier;
            MethodSource loopFindMethod = (MethodSource)javaClassSource.addMethod().setName(this.toCamelCase("find " + classifier.name()));
            ((MethodSource)loopFindMethod.setVisibility(Visibility.PUBLIC)).setFinal(true);
            loopFindMethod.setReturnType(casted.type().fqn());
            loopFindMethod.addParameter("long", "world");
            loopFindMethod.addParameter("long", "time");
            loopFindMethod.addParameter("String", "query");
            loopFindMethod.setBody("        final org.mwg.DeferCounter waiter = _graph.newCounter(1);\n        this._graph.find(world, time, \"" + casted.fqn() + "\", query, new org.mwg.Callback<org.mwg.Node[]>() {\n" + "            @Override\n" + "            public void on(org.mwg.Node[] result) {\n" + "                if (result.length > 0) {\n" + "                    waiter.wrap().on(result[0]);\n" + "                } else {\n" + "                    waiter.count();\n" + "                }\n" + "            }\n" + "        });\n" + "        return (" + casted.type().fqn() + ") waiter.waitResult();");
            MethodSource loopFindAllMethod = (MethodSource)javaClassSource.addMethod().setName(this.toCamelCase("findAll " + classifier.name()));
            ((MethodSource)loopFindAllMethod.setVisibility(Visibility.PUBLIC)).setFinal(true);
            loopFindAllMethod.setReturnType(casted.type().fqn() + "[]");
            loopFindAllMethod.addParameter("long", "world");
            loopFindAllMethod.addParameter("long", "time");
            loopFindAllMethod.setBody("        final org.mwg.DeferCounter waiter = _graph.newCounter(1);\n        this._graph.findAll(world, time, \"" + casted.fqn() + "\", new org.mwg.Callback<org.mwg.Node[]>() {\n" + "            @Override\n" + "            public void on(org.mwg.Node[] result) {\n" + "                " + casted.type().fqn() + "[] typedResult = new " + casted.type().fqn() + "[result.length];\n" + "                System.arraycopy(result, 0, typedResult, 0, result.length);\n" + "                waiter.wrap().on(typedResult);" + "            }\n" + "        });\n" + "        return (" + casted.type().fqn() + "[]) waiter.waitResult();");
        }
        this.sources.add((JavaSource)javaClassSource);
        for (JavaSource src : this.sources) {
            File targetPkg = src.getPackage() != null ? new File(target.getAbsolutePath() + File.separator + src.getPackage().replace(".", File.separator)) : target;
            targetPkg.mkdirs();
            File targetSrc = new File(targetPkg, src.getName() + ".java");
            try {
                FileWriter writer = new FileWriter(targetSrc);
                writer.write(src.toString());
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String toCamelCase(String init) {
        if (init == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder(init.length());
        boolean isFirst = true;
        for (String word : init.split(" ")) {
            if (isFirst) {
                ret.append(word);
                isFirst = false;
                continue;
            }
            if (word.isEmpty()) continue;
            ret.append(word.substring(0, 1).toUpperCase());
            ret.append(word.substring(1).toLowerCase());
        }
        return ret.toString();
    }

    private static byte nameToType(String name) {
        switch (name) {
            case "Integer": {
                return 4;
            }
            case "Long": {
                return 3;
            }
            case "String": {
                return 2;
            }
        }
        return -1;
    }

    private static String typeToClassName(String mwgTypeName) {
        byte mwgType = Generator.nameToType(mwgTypeName);
        switch (mwgType) {
            case 1: {
                return Boolean.class.getCanonicalName();
            }
            case 5: {
                return Double.class.getCanonicalName();
            }
            case 4: {
                return Integer.class.getCanonicalName();
            }
            case 3: {
                return Long.class.getCanonicalName();
            }
            case 2: {
                return String.class.getCanonicalName();
            }
        }
        return mwgTypeName;
    }
}

