/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.beans;

import java.util.regex.Pattern;
import org.apache.mina.integration.beans.AbstractPropertyEditor;

public class NumberEditor
extends AbstractPropertyEditor {
    private static final Pattern DECIMAL = Pattern.compile("[-+]?[0-9]*\\.?[0-9]*(?:[Ee][-+]?[0-9]+)?");
    private static final Pattern HEXADECIMAL = Pattern.compile("0x[0-9a-fA-F]+");
    private static final Pattern OCTET = Pattern.compile("0[0-9][0-9]*");

    @Override
    protected final String toText(Object value) {
        return value.toString();
    }

    @Override
    protected final Object toValue(String text) throws IllegalArgumentException {
        if (text.length() == 0) {
            return this.defaultValue();
        }
        if (HEXADECIMAL.matcher(text).matches()) {
            return this.toValue(text.substring(2), 16);
        }
        if (OCTET.matcher(text).matches()) {
            return this.toValue(text, 8);
        }
        if (DECIMAL.matcher(text).matches()) {
            return this.toValue(text, 10);
        }
        throw new NumberFormatException("Not a number: " + text);
    }

    protected Object toValue(String text, int radix) {
        return Integer.parseInt(text, radix);
    }

    @Override
    protected Object defaultValue() {
        return 0;
    }
}

