/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.polling;

import java.io.IOException;
import java.net.PortUnreachableException;
import java.nio.channels.ClosedSelectorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.FileRegion;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.DefaultIoFuture;
import org.apache.mina.core.service.AbstractIoService;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.session.AbstractIoSession;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.core.session.SessionState;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestQueue;
import org.apache.mina.core.write.WriteToClosedSessionException;
import org.apache.mina.transport.socket.AbstractDatagramSessionConfig;
import org.apache.mina.util.ExceptionMonitor;
import org.apache.mina.util.NamePreservingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPollingIoProcessor<T extends AbstractIoSession>
implements IoProcessor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(IoProcessor.class);
    private static final int WRITE_SPIN_COUNT = 256;
    private static final long SELECT_TIMEOUT = 10L;
    private static final Map<Class<?>, AtomicInteger> threadIds = new HashMap();
    private final String threadName;
    private final Executor executor;
    private final Queue<T> newSessions = new ConcurrentLinkedQueue<T>();
    private final Queue<T> removingSessions = new ConcurrentLinkedQueue<T>();
    private final Queue<T> flushingSessions = new ConcurrentLinkedQueue<T>();
    private final Queue<T> trafficControllingSessions = new ConcurrentLinkedQueue<T>();
    private final AtomicReference<Processor> processorRef = new AtomicReference();
    private long lastIdleCheckTime;
    private final Object disposalLock = new Object();
    private volatile boolean disposing;
    private volatile boolean disposed;
    private final DefaultIoFuture disposalFuture = new DefaultIoFuture(null);

    protected AbstractPollingIoProcessor(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        this.threadName = this.nextThreadName();
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nextThreadName() {
        int newThreadId;
        Class<?> cls = this.getClass();
        Map<Class<?>, AtomicInteger> map = threadIds;
        synchronized (map) {
            AtomicInteger threadId = threadIds.get(cls);
            if (threadId == null) {
                newThreadId = 1;
                threadIds.put(cls, new AtomicInteger(newThreadId));
            } else {
                newThreadId = threadId.incrementAndGet();
            }
        }
        return cls.getSimpleName() + '-' + newThreadId;
    }

    @Override
    public final boolean isDisposing() {
        return this.disposing;
    }

    @Override
    public final boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        if (this.disposed) {
            return;
        }
        Object object = this.disposalLock;
        synchronized (object) {
            if (!this.disposing) {
                this.disposing = true;
                this.startupProcessor();
            }
        }
        this.disposalFuture.awaitUninterruptibly();
        this.disposed = true;
    }

    protected abstract void dispose0() throws Exception;

    protected abstract int select(long var1) throws Exception;

    protected abstract int select() throws Exception;

    protected abstract boolean isSelectorEmpty();

    protected abstract void wakeup();

    protected abstract Iterator<T> allSessions();

    protected abstract Iterator<T> selectedSessions();

    protected abstract SessionState getState(T var1);

    protected Object getWriteRequestMessage(T session, WriteRequest writeRequest) {
        return writeRequest.getMessage();
    }

    protected abstract boolean isWritable(T var1);

    protected abstract boolean isReadable(T var1);

    protected abstract void setInterestedInWrite(T var1, boolean var2) throws Exception;

    protected abstract void setInterestedInRead(T var1, boolean var2) throws Exception;

    protected abstract boolean isInterestedInRead(T var1);

    protected abstract boolean isInterestedInWrite(T var1);

    protected abstract void init(T var1) throws Exception;

    protected abstract void destroy(T var1) throws Exception;

    protected abstract int read(T var1, IoBuffer var2) throws Exception;

    protected abstract int write(T var1, IoBuffer var2, int var3) throws Exception;

    protected abstract int transferFile(T var1, FileRegion var2, int var3) throws Exception;

    @Override
    public final void add(T session) {
        if (this.isDisposing()) {
            throw new IllegalStateException("Already disposed.");
        }
        this.newSessions.add(session);
        this.startupProcessor();
    }

    @Override
    public final void remove(T session) {
        this.scheduleRemove(session);
        this.startupProcessor();
    }

    private void scheduleRemove(T session) {
        this.removingSessions.add(session);
    }

    @Override
    public final void flush(T session) {
        if (this.scheduleFlush(session)) {
            this.wakeup();
        }
    }

    private boolean scheduleFlush(T session) {
        if (((AbstractIoSession)session).setScheduledForFlush(true)) {
            this.flushingSessions.add(session);
            return true;
        }
        return false;
    }

    public final void updateTrafficMask(T session) {
        this.scheduleTrafficControl(session);
        this.wakeup();
    }

    private void scheduleTrafficControl(T session) {
        this.trafficControllingSessions.add(session);
    }

    private void startupProcessor() {
        Processor processor = this.processorRef.get();
        if (processor == null && this.processorRef.compareAndSet(null, processor = new Processor())) {
            this.executor.execute(new NamePreservingRunnable(processor, this.threadName));
        }
        this.wakeup();
    }

    private int handleNewSessions() {
        AbstractIoSession session;
        int addedSessions = 0;
        while ((session = (AbstractIoSession)this.newSessions.poll()) != null) {
            if (!this.addNow(session)) continue;
            ++addedSessions;
        }
        return addedSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addNow(T session) {
        boolean registered = false;
        boolean notified = false;
        try {
            this.init(session);
            registered = true;
            session.getService().getFilterChainBuilder().buildFilterChain(session.getFilterChain());
            ((AbstractIoService)session.getService()).getListeners().fireSessionCreated((IoSession)session);
            notified = true;
        }
        catch (Throwable e) {
            if (notified) {
                this.scheduleRemove(session);
                IoFilterChain filterChain = session.getFilterChain();
                filterChain.fireExceptionCaught(e);
                this.wakeup();
            }
            ExceptionMonitor.getInstance().exceptionCaught(e);
            try {
                this.destroy(session);
            }
            catch (Exception e1) {
                ExceptionMonitor.getInstance().exceptionCaught(e1);
            }
            finally {
                registered = false;
            }
        }
        return registered;
    }

    private int removeSessions() {
        SessionState state;
        int removedSessions = 0;
        block5: while (true) {
            AbstractIoSession session;
            if ((session = (AbstractIoSession)this.removingSessions.poll()) == null) {
                return removedSessions;
            }
            state = this.getState(session);
            switch (state) {
                case OPENED: {
                    if (!this.removeNow(session)) continue block5;
                    ++removedSessions;
                    continue block5;
                }
                case CLOSING: {
                    continue block5;
                }
                case OPENING: {
                    this.newSessions.remove(session);
                    if (!this.removeNow(session)) continue block5;
                    ++removedSessions;
                    continue block5;
                }
            }
            break;
        }
        throw new IllegalStateException(String.valueOf((Object)state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeNow(T session) {
        this.clearWriteRequestQueue(session);
        try {
            this.destroy(session);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            IoFilterChain filterChain = session.getFilterChain();
            filterChain.fireExceptionCaught(e);
        }
        finally {
            this.clearWriteRequestQueue(session);
            ((AbstractIoService)session.getService()).getListeners().fireSessionDestroyed((IoSession)session);
        }
        return false;
    }

    private void clearWriteRequestQueue(T session) {
        WriteRequestQueue writeRequestQueue = ((AbstractIoSession)session).getWriteRequestQueue();
        ArrayList<WriteRequest> failedRequests = new ArrayList<WriteRequest>();
        WriteRequest req = writeRequestQueue.poll((IoSession)session);
        if (req != null) {
            Object m = req.getMessage();
            if (m instanceof IoBuffer) {
                IoBuffer buf = (IoBuffer)req.getMessage();
                if (buf.hasRemaining()) {
                    buf.reset();
                    failedRequests.add(req);
                } else {
                    IoFilterChain filterChain = session.getFilterChain();
                    filterChain.fireMessageSent(req);
                }
            } else {
                failedRequests.add(req);
            }
            while ((req = writeRequestQueue.poll((IoSession)session)) != null) {
                failedRequests.add(req);
            }
        }
        if (!failedRequests.isEmpty()) {
            WriteToClosedSessionException cause = new WriteToClosedSessionException(failedRequests);
            for (WriteRequest r : failedRequests) {
                ((AbstractIoSession)session).decreaseScheduledBytesAndMessages(r);
                r.getFuture().setException(cause);
            }
            IoFilterChain filterChain = session.getFilterChain();
            filterChain.fireExceptionCaught(cause);
        }
    }

    private void process() throws Exception {
        Iterator<T> i = this.selectedSessions();
        while (i.hasNext()) {
            AbstractIoSession session = (AbstractIoSession)i.next();
            this.process(session);
            i.remove();
        }
    }

    private void process(T session) {
        if (this.isReadable(session) && !((AbstractIoSession)session).isReadSuspended()) {
            this.read(session);
        }
        if (this.isWritable(session) && !((AbstractIoSession)session).isWriteSuspended()) {
            this.scheduleFlush(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(T session) {
        IoSessionConfig config = session.getConfig();
        IoBuffer buf = this.newReadBuffer(config.getReadBufferSize());
        boolean hasFragmentation = session.getTransportMetadata().hasFragmentation();
        try {
            int ret;
            int readBytes;
            block15: {
                readBytes = 0;
                try {
                    if (hasFragmentation) {
                        while ((ret = this.read(session, buf)) > 0) {
                            readBytes += ret;
                            if (buf.hasRemaining()) continue;
                            break block15;
                        }
                        break block15;
                    }
                    ret = this.read(session, buf);
                    if (ret > 0) {
                        readBytes = ret;
                    }
                }
                finally {
                    buf.flip();
                }
            }
            if (readBytes > 0) {
                IoFilterChain filterChain = session.getFilterChain();
                filterChain.fireMessageReceived(buf);
                buf = null;
                if (hasFragmentation) {
                    if (readBytes << 1 < config.getReadBufferSize()) {
                        ((AbstractIoSession)session).decreaseReadBufferSize();
                    } else if (readBytes == config.getReadBufferSize()) {
                        ((AbstractIoSession)session).increaseReadBufferSize();
                    }
                }
            }
            if (ret < 0) {
                this.scheduleRemove(session);
            }
        }
        catch (Throwable e) {
            if (e instanceof IOException && (!(e instanceof PortUnreachableException) || !AbstractDatagramSessionConfig.class.isAssignableFrom(config.getClass()) || ((AbstractDatagramSessionConfig)config).isCloseOnPortUnreachable())) {
                this.scheduleRemove(session);
            }
            IoFilterChain filterChain = session.getFilterChain();
            filterChain.fireExceptionCaught(e);
        }
    }

    protected IoBuffer newReadBuffer(int readBufferSize) {
        return IoBuffer.allocate(readBufferSize);
    }

    private void notifyIdleSessions(long currentTime) throws Exception {
        if (currentTime - this.lastIdleCheckTime >= 10L) {
            this.lastIdleCheckTime = currentTime;
            AbstractIoSession.notifyIdleness(this.allSessions(), currentTime);
        }
    }

    @Override
    private void flush(long currentTime) {
        AbstractIoSession firstSession = (AbstractIoSession)this.flushingSessions.peek();
        if (firstSession == null) {
            return;
        }
        AbstractIoSession session = (AbstractIoSession)this.flushingSessions.poll();
        while (true) {
            session.setScheduledForFlush(false);
            SessionState state = this.getState(session);
            switch (state) {
                case OPENED: {
                    try {
                        boolean flushedAll = this.flushNow(session, currentTime);
                        if (!flushedAll || session.getWriteRequestQueue().isEmpty(session) || session.isScheduledForFlush()) break;
                        this.scheduleFlush(session);
                    }
                    catch (Exception e) {
                        this.scheduleRemove(session);
                        IoFilterChain filterChain = session.getFilterChain();
                        filterChain.fireExceptionCaught(e);
                    }
                    break;
                }
                case CLOSING: {
                    break;
                }
                case OPENING: {
                    this.scheduleFlush(session);
                    return;
                }
                default: {
                    throw new IllegalStateException(String.valueOf((Object)state));
                }
            }
            session = (AbstractIoSession)this.flushingSessions.peek();
            if (session == null || session == firstSession) break;
            session = (AbstractIoSession)this.flushingSessions.poll();
        }
    }

    private boolean flushNow(T session, long currentTime) {
        if (!((AbstractIoSession)session).isConnected()) {
            this.scheduleRemove(session);
            return false;
        }
        boolean hasFragmentation = session.getTransportMetadata().hasFragmentation();
        WriteRequestQueue writeRequestQueue = ((AbstractIoSession)session).getWriteRequestQueue();
        int maxWrittenBytes = session.getConfig().getMaxReadBufferSize() + (session.getConfig().getMaxReadBufferSize() >>> 1);
        int writtenBytes = 0;
        WriteRequest req = null;
        try {
            this.setInterestedInWrite(session, false);
            do {
                if ((req = ((AbstractIoSession)session).getCurrentWriteRequest()) == null) {
                    req = writeRequestQueue.poll((IoSession)session);
                    if (req == null) break;
                    ((AbstractIoSession)session).setCurrentWriteRequest(req);
                }
                int localWrittenBytes = 0;
                Object message = this.getWriteRequestMessage(session, req);
                if (message instanceof IoBuffer) {
                    localWrittenBytes = this.writeBuffer(session, req, (IoBuffer)message, hasFragmentation, maxWrittenBytes - writtenBytes, currentTime);
                    if (localWrittenBytes > 0 && ((IoBuffer)this.getWriteRequestMessage(session, req)).hasRemaining()) {
                        writtenBytes += localWrittenBytes;
                        this.setInterestedInWrite(session, true);
                        return false;
                    }
                } else if (message instanceof FileRegion) {
                    localWrittenBytes = this.writeFile(session, req, hasFragmentation, maxWrittenBytes - writtenBytes, currentTime);
                    if (localWrittenBytes > 0 && ((FileRegion)message).getRemainingBytes() > 0L) {
                        writtenBytes += localWrittenBytes;
                        this.setInterestedInWrite(session, true);
                        return false;
                    }
                } else {
                    throw new IllegalStateException("Don't know how to handle message of type '" + message.getClass().getName() + "'.  Are you missing a protocol encoder?");
                }
                if (localWrittenBytes == 0) {
                    this.setInterestedInWrite(session, true);
                    return false;
                }
                if ((writtenBytes += localWrittenBytes) < maxWrittenBytes) continue;
                this.scheduleFlush(session);
                return false;
            } while (writtenBytes < maxWrittenBytes);
        }
        catch (Exception e) {
            if (req != null) {
                req.getFuture().setException(e);
            }
            IoFilterChain filterChain = session.getFilterChain();
            filterChain.fireExceptionCaught(e);
            return false;
        }
        return true;
    }

    protected int writeBuffer(T session, WriteRequest req, IoBuffer buf, boolean hasFragmentation, int maxLength, long currentTime) throws Exception {
        int localWrittenBytes = 0;
        if (buf.hasRemaining()) {
            int length = hasFragmentation ? Math.min(buf.remaining(), maxLength) : buf.remaining();
            for (int i = 256; i > 0 && (localWrittenBytes = this.write(session, buf, length)) == 0; --i) {
            }
        }
        ((AbstractIoSession)session).increaseWrittenBytes(localWrittenBytes, currentTime);
        if (!buf.hasRemaining() || !hasFragmentation && localWrittenBytes != 0) {
            buf.reset();
            this.fireMessageSent(session, req);
        }
        return localWrittenBytes;
    }

    private int writeFile(T session, WriteRequest req, boolean hasFragmentation, int maxLength, long currentTime) throws Exception {
        int localWrittenBytes;
        FileRegion region = (FileRegion)req.getMessage();
        if (region.getRemainingBytes() > 0L) {
            int length = hasFragmentation ? (int)Math.min(region.getRemainingBytes(), (long)maxLength) : (int)Math.min(Integer.MAX_VALUE, region.getRemainingBytes());
            localWrittenBytes = this.transferFile(session, region, length);
            region.update(localWrittenBytes);
        } else {
            localWrittenBytes = 0;
        }
        ((AbstractIoSession)session).increaseWrittenBytes(localWrittenBytes, currentTime);
        if (region.getRemainingBytes() <= 0L || !hasFragmentation && localWrittenBytes != 0) {
            this.fireMessageSent(session, req);
        }
        return localWrittenBytes;
    }

    private void fireMessageSent(T session, WriteRequest req) {
        ((AbstractIoSession)session).setCurrentWriteRequest(null);
        IoFilterChain filterChain = session.getFilterChain();
        filterChain.fireMessageSent(req);
    }

    private void updateTrafficMask() {
        block5: for (int queueSize = this.trafficControllingSessions.size(); queueSize > 0; --queueSize) {
            AbstractIoSession session = (AbstractIoSession)this.trafficControllingSessions.poll();
            if (session == null) {
                return;
            }
            SessionState state = this.getState(session);
            switch (state) {
                case OPENED: {
                    this.updateTrafficControl((T)session);
                    continue block5;
                }
                case CLOSING: {
                    continue block5;
                }
                case OPENING: {
                    this.trafficControllingSessions.add(session);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException(String.valueOf((Object)state));
                }
            }
        }
    }

    @Override
    public void updateTrafficControl(T session) {
        IoFilterChain filterChain;
        try {
            this.setInterestedInRead(session, !((AbstractIoSession)session).isReadSuspended());
        }
        catch (Exception e) {
            filterChain = session.getFilterChain();
            filterChain.fireExceptionCaught(e);
        }
        try {
            this.setInterestedInWrite(session, !((AbstractIoSession)session).getWriteRequestQueue().isEmpty((IoSession)session) && !((AbstractIoSession)session).isWriteSuspended());
        }
        catch (Exception e) {
            filterChain = session.getFilterChain();
            filterChain.fireExceptionCaught(e);
        }
    }

    private class Processor
    implements Runnable {
        private Processor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            assert (AbstractPollingIoProcessor.this.processorRef.get() == this);
            int nSessions = 0;
            AbstractPollingIoProcessor.this.lastIdleCheckTime = System.currentTimeMillis();
            block13: while (true) {
                try {
                    while (true) {
                        int selected = AbstractPollingIoProcessor.this.select(10L);
                        nSessions += AbstractPollingIoProcessor.this.handleNewSessions();
                        AbstractPollingIoProcessor.this.updateTrafficMask();
                        if (selected > 0) {
                            AbstractPollingIoProcessor.this.process();
                        }
                        long currentTime = System.currentTimeMillis();
                        AbstractPollingIoProcessor.this.flush(currentTime);
                        AbstractPollingIoProcessor.this.notifyIdleSessions(currentTime);
                        if ((nSessions -= AbstractPollingIoProcessor.this.removeSessions()) == 0) {
                            AbstractPollingIoProcessor.this.processorRef.set(null);
                            if (AbstractPollingIoProcessor.this.newSessions.isEmpty() && AbstractPollingIoProcessor.this.isSelectorEmpty()) {
                                assert (AbstractPollingIoProcessor.this.processorRef.get() != this);
                                break block13;
                            }
                            assert (AbstractPollingIoProcessor.this.processorRef.get() != this);
                            if (!AbstractPollingIoProcessor.this.processorRef.compareAndSet(null, this)) {
                                assert (AbstractPollingIoProcessor.this.processorRef.get() != this);
                                break block13;
                            }
                            assert (AbstractPollingIoProcessor.this.processorRef.get() == this);
                        }
                        if (!AbstractPollingIoProcessor.this.isDisposing()) continue;
                        Iterator i = AbstractPollingIoProcessor.this.allSessions();
                        while (i.hasNext()) {
                            AbstractPollingIoProcessor.this.scheduleRemove((AbstractIoSession)i.next());
                        }
                        AbstractPollingIoProcessor.this.wakeup();
                    }
                }
                catch (ClosedSelectorException e) {
                    AbstractPollingIoProcessor.this.processorRef.set(null);
                }
                catch (Throwable t) {
                    ExceptionMonitor.getInstance().exceptionCaught(t);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ExceptionMonitor.getInstance().exceptionCaught(e1);
                    }
                    continue;
                }
                break;
            }
            try {
                Object t = AbstractPollingIoProcessor.this.disposalLock;
                synchronized (t) {
                    if (AbstractPollingIoProcessor.this.isDisposing()) {
                        AbstractPollingIoProcessor.this.dispose0();
                    }
                }
            }
            catch (Throwable t) {
                ExceptionMonitor.getInstance().exceptionCaught(t);
            }
            finally {
                AbstractPollingIoProcessor.this.disposalFuture.setValue(true);
            }
        }
    }
}

