/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.io.filter;

import java.nio.ByteBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.kaazing.gateway.transport.bridge.CachingMessageEncoder;
import org.kaazing.gateway.transport.bridge.MessageEncoder;
import org.kaazing.gateway.transport.io.IoMessage;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;

public class IoMessageEncoder
extends ProtocolEncoderAdapter {
    private final CachingMessageEncoder cachingEncoder;
    private final IoBufferAllocatorEx<?> allocator;
    private final MessageEncoderImpl encoder;

    public IoMessageEncoder(IoBufferAllocatorEx<?> allocator) {
        this(CachingMessageEncoder.IO_MESSAGE_ENCODER, allocator);
    }

    public IoMessageEncoder(CachingMessageEncoder cachingEncoder, IoBufferAllocatorEx<?> allocator) {
        this.cachingEncoder = cachingEncoder;
        this.allocator = allocator;
        this.encoder = new MessageEncoderImpl();
    }

    public void encode(IoSession session, Object in, ProtocolEncoderOutput out) throws Exception {
        IoMessage message = (IoMessage)in;
        if (message.hasCache()) {
            IoBufferEx buf = this.cachingEncoder.encode(this.encoder, message, this.allocator, 10);
            out.write((Object)buf);
        } else {
            IoBufferEx buf = message.getBuffer();
            out.write((Object)buf);
        }
    }

    private class MessageEncoderImpl
    implements MessageEncoder<IoMessage> {
        private MessageEncoderImpl() {
        }

        @Override
        public IoBufferEx encode(IoBufferAllocatorEx<?> allocator, IoMessage message, int flags) {
            IoBufferEx buffer = message.getBuffer();
            ByteBuffer buf = buffer.buf();
            if ((flags & 8) != 0) {
                return allocator.wrap(buffer.buf(), flags);
            }
            ByteBuffer b = allocator.allocate(buffer.remaining(), flags);
            int start = b.position();
            b.put(buf.duplicate());
            b.limit(b.position());
            b.position(start);
            return allocator.wrap(b, flags);
        }
    }
}

