/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.kaazing.mina.core.session.IoSessionEx;

public abstract class SuspendableIoFilterAdapter
extends IoFilterAdapter {
    private final Queue<SuspendableEvent> queue = new ArrayDeque<SuspendableEvent>();
    private int suspendCount = 0;

    public final void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        if (this.isSuspended()) {
            this.queue.add(new SessionCreatedEvent(nextFilter, session));
        } else {
            this.doSessionCreated(nextFilter, session);
        }
    }

    protected void doSessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        nextFilter.sessionCreated(session);
    }

    public final void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        if (this.isSuspended()) {
            this.queue.add(new SessionOpenedEvent(nextFilter, session));
        } else {
            this.doSessionOpened(nextFilter, session);
        }
    }

    protected void doSessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        nextFilter.sessionOpened(session);
    }

    public final void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        if (this.isSuspended()) {
            this.queue.add(new SessionClosedEvent(nextFilter, session));
        } else {
            this.doSessionClosed(nextFilter, session);
        }
    }

    protected void doSessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        nextFilter.sessionClosed(session);
    }

    public final void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (this.isSuspended()) {
            this.queue.add(new MessageReceivedEvent(nextFilter, session, message));
        } else {
            this.doMessageReceived(nextFilter, session, message);
        }
    }

    protected void doMessageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        nextFilter.messageReceived(session, message);
    }

    protected void suspendIncoming(IoSession session) {
        ++this.suspendCount;
        if (this.suspendCount == 1) {
            session.suspendRead();
        }
    }

    protected void resumeIncoming(IoSession session) throws Exception {
        ResumeRunnable resumeTask = new ResumeRunnable(session);
        assert (session instanceof IoSessionEx);
        ((IoSessionEx)session).getIoExecutor().execute(resumeTask);
    }

    private boolean isSuspended() {
        return this.suspendCount > 0;
    }

    private class MessageReceivedEvent
    implements SuspendableEvent {
        private final IoFilter.NextFilter nextFilter;
        private final IoSession session;
        private final Object message;

        MessageReceivedEvent(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
            this.nextFilter = nextFilter;
            this.session = session;
            this.message = message;
        }

        @Override
        public void fire() throws Exception {
            SuspendableIoFilterAdapter.this.doMessageReceived(this.nextFilter, this.session, this.message);
        }
    }

    private class SessionClosedEvent
    implements SuspendableEvent {
        private final IoFilter.NextFilter nextFilter;
        private final IoSession session;

        SessionClosedEvent(IoFilter.NextFilter nextFilter, IoSession session) {
            this.nextFilter = nextFilter;
            this.session = session;
        }

        @Override
        public void fire() throws Exception {
            SuspendableIoFilterAdapter.this.doSessionClosed(this.nextFilter, this.session);
        }
    }

    private class SessionOpenedEvent
    implements SuspendableEvent {
        private final IoFilter.NextFilter nextFilter;
        private final IoSession session;

        SessionOpenedEvent(IoFilter.NextFilter nextFilter, IoSession session) {
            this.nextFilter = nextFilter;
            this.session = session;
        }

        @Override
        public void fire() throws Exception {
            SuspendableIoFilterAdapter.this.doSessionOpened(this.nextFilter, this.session);
        }
    }

    private class SessionCreatedEvent
    implements SuspendableEvent {
        private final IoFilter.NextFilter nextFilter;
        private final IoSession session;

        SessionCreatedEvent(IoFilter.NextFilter nextFilter, IoSession session) {
            this.nextFilter = nextFilter;
            this.session = session;
        }

        @Override
        public void fire() throws Exception {
            SuspendableIoFilterAdapter.this.doSessionCreated(this.nextFilter, this.session);
        }
    }

    private static interface SuspendableEvent {
        public void fire() throws Exception;
    }

    private class ResumeRunnable
    implements Runnable {
        private final IoSession session;

        ResumeRunnable(IoSession session) {
            this.session = session;
        }

        @Override
        public void run() {
            --SuspendableIoFilterAdapter.this.suspendCount;
            if (SuspendableIoFilterAdapter.this.suspendCount == 0) {
                while (!SuspendableIoFilterAdapter.this.queue.isEmpty()) {
                    SuspendableEvent event = (SuspendableEvent)SuspendableIoFilterAdapter.this.queue.remove();
                    try {
                        event.fire();
                    }
                    catch (Exception e) {
                        this.session.getFilterChain().fireExceptionCaught((Throwable)e);
                    }
                }
                this.session.resumeRead();
            }
        }
    }
}

