/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.security.auth.Subject;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.resource.address.IdentityResolver;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceOption;
import org.kaazing.gateway.transport.BridgeAcceptor;
import org.kaazing.gateway.transport.TypedAttributeKey;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;

public final class LoggingUtils {
    private static final String HOST_PORT_FORMAT = "%s:%d";
    private static final TypedAttributeKey<String> LOG_ID_ATTRIBUTE = new TypedAttributeKey(LoggingUtils.class, "logId");

    private LoggingUtils() {
    }

    public static String addSession(String message, IoSession session) {
        return String.format("[%s] %s", LoggingUtils.getId(session), message);
    }

    public static String getId(IoSession session) {
        String result = LOG_ID_ATTRIBUTE.get(session);
        if (result == null) {
            result = session.getTransportMetadata().getName() + "#" + session.getId();
            String user = LoggingUtils.getUserIdentifier(session);
            if (user != null) {
                result = result + " " + user;
            }
            LOG_ID_ATTRIBUTE.set(session, result);
        }
        return result;
    }

    public static void log(IoSession session, Logger logger, Throwable t) {
        LoggingUtils.log(session, logger, t.toString(), t);
    }

    public static void log(IoSession session, Logger logger, String message, Throwable t) {
        boolean isIOException = t instanceof IOException;
        if (isIOException && !logger.isInfoEnabled()) {
            return;
        }
        if (logger.isWarnEnabled()) {
            String finalMessage = t.getCause() == null ? message : message + ", caused by " + t.getCause();
            finalMessage = LoggingUtils.addSession(finalMessage, session);
            if (isIOException) {
                LoggingUtils.logIOException(finalMessage, logger, t);
            } else if (logger.isInfoEnabled()) {
                logger.warn(finalMessage, t);
            } else {
                logger.warn(finalMessage);
            }
        }
    }

    private static void logIOException(String message, Logger logger, Throwable t) {
        Throwable cause = t.getCause();
        if (cause != null) {
            logger.info(message, cause);
        } else {
            logger.info(message);
        }
    }

    static String getUserIdentifier(IoSession session) {
        IoService service = session.getService();
        boolean isAcceptor = service instanceof IoAcceptor || service instanceof BridgeAcceptor;
        SocketAddress hostPortAddress = isAcceptor ? session.getRemoteAddress() : session.getLocalAddress();
        SocketAddress identityAddress = isAcceptor ? session.getLocalAddress() : session.getRemoteAddress();
        String identity = LoggingUtils.resolveIdentity(identityAddress, (IoSessionEx)session);
        String hostPort = LoggingUtils.getHostPort(hostPortAddress);
        return identity == null ? hostPort : String.format("%s %s", identity, hostPort);
    }

    private static String resolveIdentity(SocketAddress address, IoSessionEx session) {
        if (address instanceof ResourceAddress) {
            Subject subject = session.getSubject();
            if (subject == null) {
                subject = new Subject();
            }
            return LoggingUtils.resolveIdentity((ResourceAddress)address, subject);
        }
        return null;
    }

    private static String resolveIdentity(ResourceAddress address, Subject subject) {
        IdentityResolver resolver = (IdentityResolver)address.getOption((ResourceOption)ResourceAddress.IDENTITY_RESOLVER);
        ResourceAddress transport = address.getTransport();
        if (resolver != null) {
            return resolver.resolve(subject);
        }
        if (transport != null) {
            return LoggingUtils.resolveIdentity(transport, subject);
        }
        return null;
    }

    private static String getHostPort(SocketAddress address) {
        if (address instanceof ResourceAddress) {
            ResourceAddress lowest = LoggingUtils.getLowestTransportLayer((ResourceAddress)address);
            return String.format(HOST_PORT_FORMAT, lowest.getResource().getHost(), lowest.getResource().getPort());
        }
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)address;
            return String.format(HOST_PORT_FORMAT, inet.getHostString(), inet.getPort());
        }
        return null;
    }

    static ResourceAddress getLowestTransportLayer(ResourceAddress transport) {
        if (transport.getTransport() != null) {
            return LoggingUtils.getLowestTransportLayer(transport.getTransport());
        }
        return transport;
    }
}

