/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import java.io.IOException;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.filter.logging.LogLevel;
import org.kaazing.gateway.transport.ExceptionLoggingFilter;
import org.kaazing.gateway.transport.LoggingUtils;
import org.kaazing.gateway.transport.ObjectLoggingFilter;
import org.kaazing.gateway.transport.bridge.Message;
import org.kaazing.mina.filter.codec.ProtocolCodecFilter;
import org.slf4j.Logger;

public class LoggingFilter
extends IoFilterAdapter {
    private final Logger logger;
    private final String format;
    private final String createdFormat;
    private final String openedFormat;
    private final String receivedFormat;
    private final String sentFormat;
    private final String idleFormat;
    private final String exceptionFormat;
    private final String closedFormat;
    private final String writeFormat;
    protected boolean shouldForceMoveAfterCodec = true;

    public LoggingFilter(Logger logger) {
        this(logger, "%s");
    }

    public LoggingFilter(Logger logger, IoSession session, String transportName) {
        this(logger, LoggingFilter.getLoggingFormat(session, transportName));
    }

    public LoggingFilter(Logger logger, String sessionIdFormat) {
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        if (sessionIdFormat == null) {
            throw new NullPointerException("sessionIdFormat");
        }
        this.logger = logger;
        this.format = sessionIdFormat;
        this.createdFormat = String.format("[%s] CREATED: {}", String.format(sessionIdFormat, "{}"));
        this.openedFormat = String.format("[%s] OPENED: {}", String.format(sessionIdFormat, "{}"));
        this.receivedFormat = String.format("[%s] RECEIVED: {}", String.format(sessionIdFormat, "{}", "{}"));
        this.sentFormat = String.format("[%s] SENT: {}", String.format(sessionIdFormat, "{}", "{}"));
        this.idleFormat = String.format("[%s] IDLE", String.format(sessionIdFormat, "{}"));
        this.exceptionFormat = String.format("[%s] EXCEPTION: %s", String.format(sessionIdFormat, "%s"), "%s");
        this.closedFormat = String.format("[%s] CLOSED: {}", String.format(sessionIdFormat, "{}"));
        this.writeFormat = String.format("[%s] WRITE: {}", String.format(sessionIdFormat, "{}", "{}"));
    }

    public static boolean addIfNeeded(Logger logger, IoSession session, String transportName) {
        if (!logger.isInfoEnabled()) {
            return false;
        }
        String loggingFilterName = transportName + "#logging";
        if (logger.isTraceEnabled()) {
            session.getFilterChain().addLast(loggingFilterName, (IoFilter)new ObjectLoggingFilter(logger, session, transportName));
            return true;
        }
        session.getFilterChain().addLast(loggingFilterName, (IoFilter)new ExceptionLoggingFilter(logger, session, transportName));
        return true;
    }

    public LogLevel getLevel() {
        LogLevel level = LogLevel.ERROR;
        if (this.logger.isTraceEnabled()) {
            level = LogLevel.TRACE;
        } else if (this.logger.isDebugEnabled()) {
            level = LogLevel.DEBUG;
        } else if (this.logger.isInfoEnabled()) {
            level = LogLevel.INFO;
        } else if (this.logger.isWarnEnabled()) {
            level = LogLevel.WARN;
        }
        return level;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getFormat() {
        return this.format;
    }

    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.logSessionCreated(session);
        super.sessionCreated(nextFilter, session);
        IoFilterChain filterChain = session.getFilterChain();
        IoFilterChain.Entry entry = filterChain.getEntry((IoFilter)this);
        if (entry != null) {
            entry.remove();
            filterChain.addLast(entry.getName(), entry.getFilter());
        }
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        IoFilterChain filterChain;
        IoFilterChain.Entry codecEntry;
        this.logSessionOpened(session);
        super.sessionOpened(nextFilter, session);
        if (this.shouldForceMoveAfterCodec && (codecEntry = (filterChain = session.getFilterChain()).getEntry(ProtocolCodecFilter.class)) != null) {
            IoFilterChain.Entry loggingEntry = filterChain.getEntry((IoFilter)this);
            assert (loggingEntry != null);
            loggingEntry.remove();
            codecEntry.addAfter(loggingEntry.getName(), loggingEntry.getFilter());
        }
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        this.logMessageReceived(session, message);
        super.messageReceived(nextFilter, session, message);
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        this.logMessageSent(session, writeRequest.getMessage());
        super.messageSent(nextFilter, session, writeRequest);
    }

    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
        this.logSessionIdle(session);
        super.sessionIdle(nextFilter, session, status);
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
        this.logExceptionCaught(session, cause);
        super.exceptionCaught(nextFilter, session, cause);
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.logSessionClosed(session);
        super.sessionClosed(nextFilter, session);
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        this.logFilterWrite(session, writeRequest.getMessage());
        super.filterWrite(nextFilter, session, writeRequest);
    }

    protected Strategy getSessionCreatedStrategy() {
        return Strategy.NONE;
    }

    protected Strategy getSessionOpenedStrategy() {
        return Strategy.INFO;
    }

    protected Strategy getMessageReceivedStrategy() {
        return Strategy.TRACE;
    }

    protected Strategy getMessageSentStrategy() {
        return Strategy.TRACE;
    }

    protected Strategy getSessionIdleStrategy() {
        return Strategy.TRACE;
    }

    protected Strategy getExceptionCaughtStrategy(Throwable exception) {
        return exception instanceof IOException ? Strategy.INFO : Strategy.WARN;
    }

    protected Strategy getSessionClosedStrategy() {
        return Strategy.INFO;
    }

    protected Strategy getFilterWriteStrategy() {
        return Strategy.TRACE;
    }

    protected void logSessionCreated(IoSession session) {
        this.getSessionCreatedStrategy().log(this.logger, this.createdFormat, session.getId(), session);
    }

    protected void logSessionOpened(IoSession session) {
        this.getSessionOpenedStrategy().log(this.logger, this.openedFormat, session.getId(), session);
    }

    protected void logMessageReceived(IoSession session, Object message) {
        if (this.getMessageReceivedStrategy().shouldLog(this.logger)) {
            if (message instanceof Message) {
                message = ((Message)message).toVerboseString();
            }
            this.getMessageReceivedStrategy().log(this.logger, this.receivedFormat, session.getId(), message);
        }
    }

    protected void logMessageSent(IoSession session, Object message) {
        if (this.getMessageSentStrategy().shouldLog(this.logger)) {
            if (message instanceof Message) {
                message = ((Message)message).toVerboseString();
            }
            this.getMessageSentStrategy().log(this.logger, this.sentFormat, session.getId(), message);
        }
    }

    protected void logSessionIdle(IoSession session) {
        this.getSessionIdleStrategy().log(this.logger, this.idleFormat, session.getId());
    }

    protected void logExceptionCaught(IoSession session, Throwable cause) {
        String causeMessage = cause.toString();
        if (cause.getCause() != null) {
            causeMessage = causeMessage + ", caused by " + cause.getCause().toString();
        }
        this.getExceptionCaughtStrategy(cause).log(this.logger, String.format(this.exceptionFormat, session.getId(), causeMessage), cause);
    }

    protected void logSessionClosed(IoSession session) {
        this.getSessionClosedStrategy().log(this.logger, this.closedFormat, session.getId(), session);
    }

    protected void logFilterWrite(IoSession session, Object message) {
        if (this.getFilterWriteStrategy().shouldLog(this.logger)) {
            if (message instanceof Message) {
                message = ((Message)message).toVerboseString();
            }
            this.getFilterWriteStrategy().log(this.logger, this.writeFormat, session.getId(), message);
        }
    }

    protected static String getLoggingFormat(IoSession session, String transportName) {
        String user = LoggingUtils.getUserIdentifier(session);
        String format = transportName + "#%s";
        if (user != null) {
            format = format + " " + user.replace("%", "%%");
        }
        return format;
    }

    private static boolean shouldLog(Logger logger, LogLevel level) {
        switch (level) {
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case ERROR: {
                return logger.isErrorEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case NONE: {
                return false;
            }
            case TRACE: {
                return logger.isTraceEnabled();
            }
            case WARN: {
                return logger.isWarnEnabled();
            }
        }
        return false;
    }

    private static void log(Logger logger, LogLevel eventLevel, String message) {
        switch (eventLevel) {
            case TRACE: {
                logger.trace(message);
                return;
            }
            case DEBUG: {
                logger.debug(message);
                return;
            }
            case INFO: {
                logger.info(message);
                return;
            }
            case WARN: {
                logger.warn(message);
                return;
            }
            case ERROR: {
                logger.error(message);
                return;
            }
        }
    }

    private static void log(Logger logger, LogLevel eventLevel, String message, Throwable cause) {
        switch (eventLevel) {
            case TRACE: {
                logger.trace(message, cause);
                return;
            }
            case DEBUG: {
                logger.debug(message, cause);
                return;
            }
            case INFO: {
                logger.info(message, cause);
                return;
            }
            case WARN: {
                logger.warn(message, cause);
                return;
            }
            case ERROR: {
                logger.error(message, cause);
                return;
            }
        }
    }

    protected static void log(Logger logger, LogLevel eventLevel, String message, Object param) {
        switch (eventLevel) {
            case TRACE: {
                logger.trace(message, param);
                return;
            }
            case DEBUG: {
                logger.debug(message, param);
                return;
            }
            case INFO: {
                logger.info(message, param);
                return;
            }
            case WARN: {
                logger.warn(message, param);
                return;
            }
            case ERROR: {
                logger.error(message, param);
                return;
            }
        }
    }

    private static void log(Logger logger, LogLevel eventLevel, String message, Object param1, Object param2) {
        switch (eventLevel) {
            case TRACE: {
                logger.trace(message, param1, param2);
                return;
            }
            case DEBUG: {
                logger.debug(message, param1, param2);
                return;
            }
            case INFO: {
                logger.info(message, param1, param2);
                return;
            }
            case WARN: {
                logger.warn(message, param1, param2);
                return;
            }
            case ERROR: {
                logger.error(message, param1, param2);
                return;
            }
        }
    }

    public static void moveAfterCodec(IoSession session) {
        IoFilterChain filterChain = session.getFilterChain();
        IoFilterChain.Entry loggingEntry = filterChain.getEntry(LoggingFilter.class);
        if (loggingEntry == null) {
            return;
        }
        IoFilterChain.Entry codecEntry = filterChain.getEntry(ProtocolCodecFilter.class);
        if (codecEntry != null) {
            loggingEntry.remove();
            codecEntry.addAfter(loggingEntry.getName(), loggingEntry.getFilter());
        }
    }

    protected static enum Strategy {
        DEBUG(LogLevel.DEBUG),
        ERROR(LogLevel.ERROR),
        INFO(LogLevel.INFO),
        NONE(LogLevel.NONE),
        TRACE(LogLevel.TRACE),
        WARN(LogLevel.WARN);

        final LogLevel level;

        private Strategy(LogLevel level) {
            this.level = level;
        }

        boolean shouldLog(Logger logger) {
            return LoggingFilter.shouldLog(logger, this.level);
        }

        void log(Logger logger, String message, Throwable t) {
            if (this.shouldLog(logger)) {
                Throwable stack;
                boolean isIOException = t instanceof IOException;
                Throwable throwable = stack = isIOException ? t.getCause() : t;
                if (stack != null) {
                    LoggingFilter.log(logger, this.level, message, stack);
                } else {
                    LoggingFilter.log(logger, this.level, message);
                }
            }
        }

        void log(Logger logger, String message, Object param1) {
            if (this.shouldLog(logger)) {
                LoggingFilter.log(logger, this.level, message, param1);
            }
        }

        void log(Logger logger, String message, Object param1, Object param2) {
            if (this.shouldLog(logger)) {
                LoggingFilter.log(logger, this.level, message, param1, param2);
            }
        }
    }
}

