/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.transport.ProxyHandler;

public class DirectProxyHandler
extends ProxyHandler {
    public static final ProxyHandler DIRECT_PROXY_HANDLER = new DirectProxyHandler();

    private DirectProxyHandler() {
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        IoSession proxySession = this.getProxySession(session);
        proxySession.getFilterChain().fireExceptionCaught(cause);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        IoSession proxySession = this.getProxySession(session);
        proxySession.getFilterChain().fireMessageReceived(message);
    }

    public void sessionClosed(IoSession session) throws Exception {
        IoSession proxySession = this.getProxySession(session);
        if (!proxySession.isClosing()) {
            proxySession.close(false);
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        IoSession proxySession = this.getProxySession(session);
        proxySession.getFilterChain().fireSessionIdle(status);
    }

    private IoSession getProxySession(IoSession session) {
        return (IoSession)session.getAttribute((Object)PROXY_SESSION_KEY);
    }
}

