/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.test;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.kaazing.gateway.transport.IoHandlerAdapter;
import org.kaazing.mina.core.session.IoSessionEx;
import org.kaazing.test.util.ThrowableContainer;

public abstract class TransportTestIoHandlerAdapter
extends IoHandlerAdapter<IoSessionEx> {
    private final CountDownLatch latch;
    private final ThrowableContainer failures;

    public TransportTestIoHandlerAdapter() {
        this(0);
    }

    public TransportTestIoHandlerAdapter(int desiredCount) {
        this.latch = new CountDownLatch(desiredCount);
        this.failures = new ThrowableContainer();
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        boolean result = this.latch.await(timeout, unit);
        if (!result) {
            Assert.fail((String)this.getCheckpointFailureMessage());
        }
        if (!this.failures.isEmpty()) {
            Assert.fail((String)this.failures.toString());
        }
        return result;
    }

    public void checkpoint() {
        this.latch.countDown();
    }

    public void assertEquals(Object s1, Object s2) {
        try {
            Assert.assertEquals((Object)s1, (Object)s2);
        }
        catch (AssertionError error) {
            this.failures.add((Throwable)((Object)error));
        }
    }

    public void assertEquals(String msg, Object s1, Object s2) {
        try {
            Assert.assertEquals((String)msg, (Object)s1, (Object)s2);
        }
        catch (AssertionError error) {
            this.failures.add((Throwable)((Object)error));
        }
    }

    public void assertEquals(int s1, int s2) {
        try {
            Assert.assertEquals((long)s1, (long)s2);
        }
        catch (AssertionError error) {
            this.failures.add((Throwable)((Object)error));
        }
    }

    public void assertEquals(double s1, double s2) {
        try {
            Assert.assertEquals((double)s1, (double)s2);
        }
        catch (AssertionError error) {
            this.failures.add((Throwable)((Object)error));
        }
    }

    public void assertEquals(boolean s1, boolean s2) {
        try {
            Assert.assertEquals((Object)s1, (Object)s2);
        }
        catch (AssertionError error) {
            this.failures.add((Throwable)((Object)error));
        }
    }

    public abstract String getCheckpointFailureMessage();
}

