/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import java.net.SocketAddress;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.transport.BridgeAcceptor;
import org.kaazing.gateway.transport.BridgeConnector;
import org.kaazing.gateway.transport.Direction;
import org.kaazing.gateway.transport.TypedAttributeKey;
import org.kaazing.gateway.transport.bridge.CachingMessageEncoder;
import org.kaazing.mina.core.session.IoSessionEx;

public interface BridgeSession
extends IoSessionEx {
    public static final TypedAttributeKey<String> NEXT_PROTOCOL_KEY = new TypedAttributeKey(BridgeSession.class, "nextProtocol");
    public static final TypedAttributeKey<ResourceAddress> LOCAL_ADDRESS = new TypedAttributeKey<ResourceAddress>(BridgeAcceptor.class, "localAddress"){
        private static final long serialVersionUID = 1L;

        @Override
        public ResourceAddress get(IoSession session) {
            SocketAddress localAddress = session.getLocalAddress();
            if (localAddress instanceof ResourceAddress) {
                return (ResourceAddress)localAddress;
            }
            return (ResourceAddress)super.get(session);
        }
    };
    public static final TypedAttributeKey<ResourceAddress> REMOTE_ADDRESS = new TypedAttributeKey<ResourceAddress>(BridgeConnector.class, "remoteAddress"){
        private static final long serialVersionUID = 1L;

        @Override
        public ResourceAddress get(IoSession session) {
            SocketAddress remoteAddress = session.getRemoteAddress();
            if (remoteAddress instanceof ResourceAddress) {
                return (ResourceAddress)remoteAddress;
            }
            return (ResourceAddress)super.get(session);
        }
    };

    public IoSessionEx getParent();

    public Direction getDirection();

    public CachingMessageEncoder getMessageEncoder();

    public ResourceAddress getLocalAddress();

    public ResourceAddress getRemoteAddress();
}

