/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.test;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;
import org.junit.Assert;
import org.kaazing.test.util.ThrowableContainer;

public abstract class TransportTestConnectSessionInitializer
implements IoSessionInitializer<ConnectFuture> {
    private final CountDownLatch latch;
    private final ThrowableContainer failures;
    public static TransportTestConnectSessionInitializer EMPTY_INITIALIZER = new TransportTestConnectSessionInitializer(){

        @Override
        public String getCheckpointFailureMessage() {
            return "A Failure occurred on a NOOP connect session initializer.";
        }

        public void initializeSession(IoSession session, ConnectFuture future) {
        }
    };

    public TransportTestConnectSessionInitializer() {
        this(0);
    }

    public TransportTestConnectSessionInitializer(int desiredCount) {
        this.latch = new CountDownLatch(desiredCount);
        this.failures = new ThrowableContainer();
    }

    public void checkpoint() {
        this.latch.countDown();
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        boolean result = this.latch.await(timeout, unit);
        if (!result) {
            Assert.fail((String)this.getCheckpointFailureMessage());
        }
        if (!this.failures.isEmpty()) {
            Assert.fail((String)this.failures.toString());
        }
        return result;
    }

    public void assertEquals(Object s1, Object s2) {
        try {
            Assert.assertEquals((Object)s1, (Object)s2);
        }
        catch (AssertionError error) {
            this.failures.add((Throwable)((Object)error));
        }
    }

    public void assertEquals(int s1, int s2) {
        try {
            Assert.assertEquals((long)s1, (long)s2);
        }
        catch (AssertionError error) {
            this.failures.add((Throwable)((Object)error));
        }
    }

    public void assertEquals(double s1, double s2) {
        try {
            Assert.assertEquals((double)s1, (double)s2);
        }
        catch (AssertionError error) {
            this.failures.add((Throwable)((Object)error));
        }
    }

    public void assertEquals(boolean s1, boolean s2) {
        try {
            Assert.assertEquals((Object)s1, (Object)s2);
        }
        catch (AssertionError error) {
            this.failures.add((Throwable)((Object)error));
        }
    }

    public abstract String getCheckpointFailureMessage();
}

