/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoHandlerAdapter<T extends IoSession>
implements IoHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public final void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        this.doExceptionCaught(session, cause);
    }

    protected void doExceptionCaught(T session, Throwable cause) throws Exception {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("EXCEPTION, please implement " + this.getClass().getName() + ".doExceptionCaught() for proper handling:", cause);
        }
    }

    public final void messageReceived(IoSession session, Object message) throws Exception {
        this.doMessageReceived(session, message);
    }

    protected void doMessageReceived(T session, Object message) throws Exception {
    }

    public final void messageSent(IoSession session, Object message) throws Exception {
        this.doMessageSent(session, message);
    }

    protected void doMessageSent(T session, Object message) throws Exception {
    }

    public final void sessionClosed(IoSession session) throws Exception {
        this.doSessionClosed(session);
    }

    protected void doSessionClosed(T session) throws Exception {
    }

    public final void sessionCreated(IoSession session) throws Exception {
        this.doSessionCreated(session);
    }

    protected void doSessionCreated(T session) throws Exception {
    }

    public final void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        this.doSessionIdle(session, status);
    }

    protected void doSessionIdle(T session, IdleStatus status) throws Exception {
    }

    public final void sessionOpened(IoSession session) throws Exception {
        this.doSessionOpened(session);
    }

    protected void doSessionOpened(T session) throws Exception {
    }
}

