/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import java.nio.ByteBuffer;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.Direction;
import org.kaazing.gateway.transport.bridge.CachingMessageEncoder;
import org.kaazing.gateway.transport.bridge.Message;
import org.kaazing.gateway.transport.bridge.MessageBuffer;
import org.kaazing.gateway.transport.bridge.MessageEncoder;
import org.kaazing.mina.core.buffer.AbstractIoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.kaazing.mina.filter.codec.ProtocolCodecSessionEx;

public class BridgeCodecSession
extends ProtocolCodecSessionEx
implements BridgeSession {
    private static final MessageBufferAllocator MESSAGE_BUFFER_ALLOCATOR = new MessageBufferAllocator();
    private final IoBufferAllocatorEx<?> allocator;
    private final CachingMessageEncoder encoder;
    private Direction direction;
    private IoSessionEx parent;

    public BridgeCodecSession() {
        this(CachingMessageEncoder.IO_MESSAGE_ENCODER, (IoBufferAllocatorEx<?>)MESSAGE_BUFFER_ALLOCATOR);
    }

    public BridgeCodecSession(String cacheKey) {
        this(new CachingMessageEncoderImpl(cacheKey), (IoBufferAllocatorEx<?>)MESSAGE_BUFFER_ALLOCATOR);
    }

    private BridgeCodecSession(CachingMessageEncoder encoder, IoBufferAllocatorEx<?> allocator) {
        this.encoder = encoder;
        this.allocator = allocator;
        this.direction = Direction.BOTH;
    }

    @Override
    public CachingMessageEncoder getMessageEncoder() {
        return this.encoder;
    }

    public IoBufferAllocatorEx<?> getBufferAllocator() {
        return this.allocator;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    public void setParent(IoSessionEx parent) {
        this.parent = parent;
    }

    @Override
    public IoSessionEx getParent() {
        return this.parent;
    }

    @Override
    public ResourceAddress getLocalAddress() {
        return null;
    }

    @Override
    public ResourceAddress getRemoteAddress() {
        return null;
    }

    private static final class UnsharedMessageBuffer
    extends MessageBuffer<Message> {
        public UnsharedMessageBuffer(MessageBuffer<Message> parent, ByteBuffer buf) {
            super(parent, buf);
        }

        public UnsharedMessageBuffer(ByteBuffer buf) {
            super(buf);
        }

        public int flags() {
            return 0;
        }

        protected SharedMessageBuffer asSharedBuffer0() {
            return new SharedMessageBuffer(this.buf());
        }

        protected UnsharedMessageBuffer asUnsharedBuffer0() {
            return this;
        }

        @Override
        protected MessageBuffer<Message> create0(MessageBuffer<Message> parent, ByteBuffer buf) {
            return new UnsharedMessageBuffer(parent, buf);
        }
    }

    private static final class SharedMessageBuffer
    extends MessageBuffer<Message> {
        public SharedMessageBuffer(MessageBuffer<Message> parent, ByteBuffer buf) {
            super(parent, buf);
        }

        public SharedMessageBuffer(ByteBuffer buf) {
            super(buf);
        }

        public int flags() {
            return 2;
        }

        protected SharedMessageBuffer asSharedBuffer0() {
            return this;
        }

        protected UnsharedMessageBuffer asUnsharedBuffer0() {
            return new UnsharedMessageBuffer(this.buf());
        }

        @Override
        protected MessageBuffer<Message> create0(MessageBuffer<Message> parent, ByteBuffer buf) {
            return new SharedMessageBuffer(parent, buf);
        }
    }

    private static class MessageBufferAllocator
    extends AbstractIoBufferAllocatorEx<MessageBuffer<Message>> {
        private MessageBufferAllocator() {
        }

        public ByteBuffer allocate(int capacity, int flags) {
            return this.allocateNioBuffer0(capacity, flags);
        }

        public MessageBuffer<Message> wrap(ByteBuffer nioBuffer, int flags) {
            boolean shared = (flags & 2) != 0;
            return shared ? new SharedMessageBuffer(nioBuffer) : new UnsharedMessageBuffer(nioBuffer);
        }
    }

    private static final class CachingMessageEncoderImpl
    extends CachingMessageEncoder {
        private final String cacheKey;

        private CachingMessageEncoderImpl(String cacheKey) {
            this.cacheKey = cacheKey;
        }

        @Override
        public <T extends Message> IoBufferEx encode(MessageEncoder<T> encoder, T message, IoBufferAllocatorEx<?> allocator, int flags) {
            return this.encode(this.cacheKey, encoder, message, allocator, flags);
        }
    }
}

