/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import java.net.URI;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.service.IoHandler;
import org.kaazing.gateway.resource.address.Comparators;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.transport.BridgeSessionInitializer;

public abstract class Bindings<B extends Binding> {
    private final ConcurrentNavigableMap<ResourceAddress, B> bindings;

    protected Bindings(Comparator<ResourceAddress> comparator) {
        this.bindings = new ConcurrentSkipListMap<ResourceAddress, B>(comparator);
    }

    public boolean isEmpty() {
        return this.bindings.isEmpty();
    }

    public abstract Binding addBinding(Binding var1);

    public abstract Binding getBinding(ResourceAddress var1);

    public abstract boolean removeBinding(ResourceAddress var1, Binding var2);

    public String toString() {
        Iterator<Map.Entry<ResourceAddress, B>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        while (true) {
            Map.Entry<ResourceAddress, B> e = i.next();
            ResourceAddress key = e.getKey();
            Binding value = (Binding)e.getValue();
            URI location = key.getResource();
            String nextProtocol = (String)key.getOption(ResourceAddress.NEXT_PROTOCOL);
            String nextProtocolStr = nextProtocol == null ? "" : " " + nextProtocol;
            sb.append("  ").append('[').append(location).append(nextProtocolStr).append(']');
            sb.append('=');
            sb.append(value);
            if (!i.hasNext()) {
                return sb.append("\n}").toString();
            }
            sb.append(',').append('\n');
        }
    }

    protected Set<Map.Entry<ResourceAddress, B>> entrySet() {
        return this.bindings.entrySet();
    }

    protected final B addBinding0(B newBinding) {
        ResourceAddress bindAddress = ((Binding)newBinding).bindAddress();
        Binding oldBinding = (Binding)this.bindings.get(bindAddress);
        if (oldBinding != null) {
            IoHandler newHandler = ((Binding)newBinding).handler();
            IoHandler oldHandler = oldBinding.handler();
            if (oldHandler != null && newHandler != oldHandler) {
                throw new RuntimeException("Tried to bind address " + bindAddress + " to a different handler (old,new) = (" + oldHandler + "," + newHandler + ")");
            }
            oldBinding.incrementReferenceCount();
            return null;
        }
        Binding binding = (Binding)this.bindings.putIfAbsent(bindAddress, newBinding);
        if (binding != null) {
            if (this.equivalent((Binding)newBinding, binding)) {
                binding.incrementReferenceCount();
                binding = null;
            }
        } else {
            ((Binding)newBinding).incrementReferenceCount();
        }
        return (B)binding;
    }

    protected final boolean equivalent(Binding newBinding, Binding binding) {
        return binding.bindAddress().equals((Object)newBinding.bindAddress()) && binding.handler() == newBinding.handler();
    }

    public final B getBinding0(ResourceAddress address) {
        return (B)((Binding)this.bindings.get(address));
    }

    protected final boolean removeBinding0(ResourceAddress address, B binding) {
        B binding0 = this.getBinding0(address);
        if (binding0 != null && ((Binding)binding).equals((Binding)binding0) && ((Binding)binding).decrementReferenceCount() == 0) {
            return this.bindings.remove(address, binding);
        }
        return false;
    }

    public static class Binding {
        private final ResourceAddress bindAddress;
        private final IoHandler handler;
        private final BridgeSessionInitializer<? extends IoFuture> initializer;
        private final AtomicInteger referenceCount;

        public Binding(ResourceAddress bindAddress, IoHandler handler) {
            this(bindAddress, handler, null);
        }

        public Binding(ResourceAddress bindAddress, IoHandler handler, BridgeSessionInitializer<? extends IoFuture> initializer) {
            if (bindAddress == null) {
                throw new NullPointerException("bindAddress");
            }
            if (handler == null) {
                throw new NullPointerException("handler");
            }
            this.bindAddress = bindAddress;
            this.handler = handler;
            this.initializer = initializer;
            this.referenceCount = new AtomicInteger(0);
        }

        protected Binding(ResourceAddress bindAddress) {
            if (bindAddress == null) {
                throw new NullPointerException("bindAddress");
            }
            this.bindAddress = bindAddress;
            this.handler = null;
            this.initializer = null;
            this.referenceCount = new AtomicInteger(0);
        }

        public final ResourceAddress bindAddress() {
            return this.bindAddress;
        }

        public final IoHandler handler() {
            return this.handler;
        }

        public final BridgeSessionInitializer<? extends IoFuture> initializer() {
            return this.initializer;
        }

        public final int referenceCount() {
            return this.referenceCount.get();
        }

        public final int incrementReferenceCount() {
            return this.referenceCount.incrementAndGet();
        }

        public final int decrementReferenceCount() {
            return this.referenceCount.decrementAndGet();
        }

        public int hashCode() {
            int hashCode = this.bindAddress.hashCode();
            if (this.handler != null) {
                hashCode = hashCode * 31 + this.handler.hashCode();
            }
            if (this.initializer != null) {
                hashCode = hashCode * 31 + this.initializer.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Binding)) {
                return false;
            }
            Binding that = (Binding)o;
            return this.equals(that);
        }

        public String toString() {
            String nextProtocol = (String)this.bindAddress.getOption(ResourceAddress.NEXT_PROTOCOL);
            nextProtocol = nextProtocol == null ? "" : " " + nextProtocol;
            return String.format("([%s%s],0x%x,0x%x,#%d)", this.bindAddress.getResource(), nextProtocol, System.identityHashCode(this.handler), System.identityHashCode(this.initializer), this.referenceCount());
        }

        protected final boolean equals(Binding that) {
            return this == that || this.bindAddress.equals((Object)that.bindAddress) && this.handler == that.handler && this.initializer == that.initializer;
        }
    }

    public static class Default
    extends Bindings<Binding> {
        private static final Comparator<ResourceAddress> BINDINGS_COMPARATOR = Comparators.compareResourceOriginPathAlternatesAndProtocolStack();

        public Default() {
            super(BINDINGS_COMPARATOR);
        }

        @Override
        public Binding addBinding(Binding newBinding) {
            return this.addBinding0(newBinding);
        }

        @Override
        public Binding getBinding(ResourceAddress address) {
            return this.getBinding0(address);
        }

        @Override
        public boolean removeBinding(ResourceAddress address, Binding binding) {
            return this.removeBinding0(address, binding);
        }
    }
}

