/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.DefaultIoSessionDataStructureFactory;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionDataStructureFactory;
import org.apache.mina.core.session.IoSessionInitializer;
import org.apache.mina.util.ExceptionMonitor;
import org.kaazing.gateway.transport.AbstractBridgeSession;
import org.kaazing.gateway.transport.BridgeService;
import org.kaazing.gateway.transport.LoggingFilter;
import org.kaazing.mina.core.service.AbstractIoServiceEx;
import org.kaazing.mina.core.service.IoProcessorEx;
import org.kaazing.mina.core.session.IoSessionConfigEx;
import org.slf4j.Logger;

public abstract class AbstractBridgeService<T extends AbstractBridgeSession<?, ?>>
extends AbstractIoServiceEx
implements BridgeService {
    private IoProcessorEx<T> processor;

    protected AbstractBridgeService(IoSessionConfigEx sessionConfig) {
        super(sessionConfig, new Executor(){

            @Override
            public void execute(Runnable command) {
            }
        });
        this.setSessionDataStructureFactory((IoSessionDataStructureFactory)new DefaultIoSessionDataStructureFactory());
    }

    protected abstract Logger getLogger();

    protected void init() {
        this.processor = this.initProcessor();
        this.setHandler(this.initHandler());
    }

    protected abstract IoProcessorEx<T> initProcessor();

    protected abstract IoHandler initHandler();

    public abstract TransportMetadata getTransportMetadata();

    protected IoFuture dispose0() throws Exception {
        return null;
    }

    protected T newSession(Callable<T> sessionCreator) throws Exception {
        return this.newSession(null, sessionCreator);
    }

    protected T newSession(IoSessionInitializer<? extends IoFuture> initializer, Callable<T> sessionCreator) throws Exception {
        return this.newSession(initializer, null, sessionCreator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T newSession(IoSessionInitializer<? extends IoFuture> initializer, IoFuture future, Callable<T> sessionCreator) throws Exception {
        AbstractBridgeSession session;
        IoProcessorEx<T> processor;
        IoProcessorEx<T> ioProcessorEx = processor = this.getProcessor();
        synchronized (ioProcessorEx) {
            session = (AbstractBridgeSession)sessionCreator.call();
            processor.add((IoSession)session);
        }
        this.initSession((IoSession)session, future, initializer);
        IoFilterChain filterChain = session.getFilterChain();
        try {
            this.getFilterChainBuilder().buildFilterChain(filterChain);
        }
        catch (Throwable t) {
            ExceptionMonitor.getInstance().exceptionCaught(t);
        }
        this.addLoggerFilter(session, this.getLogger());
        this.getListeners().fireSessionCreated((IoSession)session);
        return (T)session;
    }

    private void addLoggerFilter(T session, Logger logger) {
        if (logger != null) {
            LoggingFilter.addIfNeeded(logger, session, this.getTransportMetadata().getName());
            if (((AbstractBridgeSession)session).getParent() != null) {
                LoggingFilter.moveAfterCodec((IoSession)((AbstractBridgeSession)session).getParent());
            }
        }
    }

    protected IoProcessorEx<T> getProcessor() {
        return this.processor;
    }

    public void removeBridgeFilters(IoFilterChain filterChain) {
    }

    public void addBridgeFilters(IoFilterChain filterChain) {
    }

    protected final void removeFilter(IoFilterChain filterChain, String name) {
        if (filterChain.contains(name)) {
            filterChain.remove(name);
        }
    }

    protected final void removeFilter(IoFilterChain filterChain, IoFilter filter) {
        if (filterChain.contains(filter)) {
            filterChain.remove(filter);
        }
    }
}

