/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSessionInitializer;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.transport.AbstractBridgeService;
import org.kaazing.gateway.transport.AbstractBridgeSession;
import org.kaazing.gateway.transport.BridgeConnectHandler;
import org.kaazing.gateway.transport.BridgeConnectProcessor;
import org.kaazing.gateway.transport.BridgeConnector;
import org.kaazing.mina.core.service.IoProcessorEx;
import org.kaazing.mina.core.session.IoSessionConfigEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBridgeConnector<S extends AbstractBridgeSession<?, ?>>
extends AbstractBridgeService<S>
implements BridgeConnector {
    protected final Logger logger = LoggerFactory.getLogger((String)String.format("transport.%s.connect", this.getTransportMetadata().getName()));
    private final AtomicBoolean started = new AtomicBoolean(false);

    protected AbstractBridgeConnector(IoSessionConfigEx sessionConfig) {
        super(sessionConfig);
    }

    @Override
    protected IoProcessorEx<S> initProcessor() {
        return new BridgeConnectProcessor();
    }

    @Override
    protected IoHandler initHandler() {
        return new BridgeConnectHandler();
    }

    protected abstract boolean canConnect(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ConnectFuture connect(ResourceAddress address, IoHandler handler, IoSessionInitializer<? extends ConnectFuture> initializer) {
        URI location = address.getResource();
        String schemeName = location.getScheme();
        if (!this.canConnect(schemeName)) {
            throw new IllegalArgumentException(String.format("Unexpected scheme \"%s\" for URI: %s", schemeName, location));
        }
        if (!this.started.get()) {
            AtomicBoolean atomicBoolean = this.started;
            synchronized (atomicBoolean) {
                if (!this.started.get()) {
                    this.init();
                    this.started.set(true);
                }
            }
        }
        return this.connectInternal(address, handler, initializer);
    }

    @Override
    public void connectInit(ResourceAddress address) {
    }

    @Override
    public void connectDestroy(ResourceAddress address) {
    }

    protected abstract <T extends ConnectFuture> ConnectFuture connectInternal(ResourceAddress var1, IoHandler var2, IoSessionInitializer<T> var3);

    @Override
    protected Logger getLogger() {
        return this.logger;
    }
}

