/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.test;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.jmock.api.Action;
import org.jmock.api.Invocation;
import org.jmock.lib.action.CustomAction;
import org.kaazing.gateway.transport.TypedAttributeKey;
import org.kaazing.gateway.transport.test.AttributeKeyMatching;
import org.kaazing.gateway.transport.test.ByteBufferMatching;
import org.kaazing.gateway.transport.test.ReadBytes;
import org.kaazing.gateway.transport.test.SetIoSessionClosed;
import org.kaazing.gateway.transport.test.TypedAttributeKeyMatching;
import org.kaazing.gateway.transport.test.VariableMatcher;

public class Expectations
extends org.jmock.Expectations {
    private Map<String, Object> variables = new HashMap<String, Object>();

    public Matcher<AttributeKey> attributeKeyMatching(String regex) {
        return new AttributeKeyMatching(regex);
    }

    public Matcher<ByteBuffer> byteBufferMatching(String regex) {
        return new ByteBufferMatching(regex);
    }

    public Matcher<Long> integerBetween(final long min, final long max) {
        return new BaseMatcher<Long>(){

            public boolean matches(Object arg0) {
                long value = (Long)arg0;
                return value <= max && value >= min;
            }

            public void describeTo(Description arg0) {
                arg0.appendText("integer between or equal to " + min + " and " + max);
            }
        };
    }

    public Matcher<String> stringMatching(final String regex) {
        return new BaseMatcher<String>(){

            public boolean matches(Object arg0) {
                String value = (String)arg0;
                return value.matches(regex);
            }

            public void describeTo(Description arg0) {
                arg0.appendText("string matches regular expression " + regex);
            }
        };
    }

    public Matcher<List<String>> stringListMatching(final String ... contents) {
        return new BaseMatcher<List<String>>(){

            public boolean matches(Object arg0) {
                return arg0 instanceof List && ((List)arg0).equals(Arrays.asList(contents));
            }

            public void describeTo(Description arg0) {
                StringBuilder b = new StringBuilder();
                if (contents != null) {
                    b.append("[");
                    for (String e : contents) {
                        b.append(e);
                        b.append(',');
                    }
                    b.replace(b.length() - 1, b.length(), "]");
                }
                arg0.appendText("list of string matches contents " + b.toString());
            }
        };
    }

    public Matcher<TypedAttributeKey<?>> typedAttributeKeyMatching(String regex) {
        return new TypedAttributeKeyMatching(regex);
    }

    public <T> Matcher<T> variable(String variableName, Class<T> clazz) {
        return new VariableMatcher<T>(variableName, clazz, this);
    }

    public Matcher<WriteRequest> hasMessage(Object message) {
        return new HasMessage(message);
    }

    public Matcher<WriteRequest> hasMessage(Matcher<Object> message) {
        return new HasMessage((Matcher)message);
    }

    public Matcher<IoBuffer> ioBufferMatching(final byte[] bytes) {
        return new BaseMatcher<IoBuffer>(){

            public boolean matches(Object item) {
                IoBuffer buf = (IoBuffer)item;
                if (buf.remaining() != bytes.length) {
                    return false;
                }
                for (int i = 0; i < bytes.length; ++i) {
                    if (buf.get(i) == bytes[i]) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("buffer contains bytes");
            }
        };
    }

    public Matcher<IoBuffer> hasRemaining(final int remaining) {
        return new BaseMatcher<IoBuffer>(){

            public boolean matches(Object item) {
                IoBuffer buf = (IoBuffer)item;
                return buf.remaining() == remaining;
            }

            public void describeTo(Description description) {
                description.appendText(String.format("buffer has %d remaining bytes", remaining));
            }
        };
    }

    public Matcher<WriteRequest> writeRequestWithMessage(final Object message) {
        return new BaseMatcher<WriteRequest>(){

            public boolean matches(Object arg0) {
                WriteRequest request = (WriteRequest)arg0;
                return message.equals(request.getMessage());
            }

            public void describeTo(Description arg0) {
                arg0.appendText("write request containing a message equal to " + message);
            }
        };
    }

    public Action closeSession(final int parameterIndex) {
        return new CustomAction("close session"){

            public Object invoke(Invocation invocation) throws Throwable {
                ((IoSession)invocation.getParameter(parameterIndex)).close(false);
                return null;
            }
        };
    }

    public Action countDown(final CountDownLatch latch) {
        return new CustomAction("count down latch"){

            public Object invoke(Invocation invocation) throws Throwable {
                latch.countDown();
                return null;
            }
        };
    }

    public CustomAction setSessionClosed(IoSession session) {
        return new SetIoSessionClosed(session);
    }

    public CustomAction readBytes(byte[] srcBytes) {
        return new ReadBytes("read bytes", srcBytes);
    }

    public Object lookup(String variableName) {
        return this.variables.get(variableName);
    }

    public <T> T lookup(String variableName, Class<T> clazz) {
        return clazz.cast(this.variables.get(variableName));
    }

    public Action saveParameter(final String variableName, final int parameterIndex) {
        return new CustomAction("save parameter"){

            public Object invoke(Invocation invocation) throws Throwable {
                Expectations.this.variables.put(variableName, invocation.getParameter(parameterIndex));
                return null;
            }
        };
    }

    public <T> Action saveParameter(final AtomicReference<T> parameterStorage, final int parameterIndex) {
        return new CustomAction("save parameter"){

            public Object invoke(Invocation invocation) throws Throwable {
                parameterStorage.set(invocation.getParameter(parameterIndex));
                return null;
            }
        };
    }

    public Action returnVariable(final String variableName) {
        return new CustomAction("return variable"){

            public Object invoke(Invocation invocation) throws Throwable {
                return Expectations.this.variables.get(variableName);
            }
        };
    }

    private static final class HasMessage
    extends BaseMatcher<WriteRequest> {
        private final Matcher<Object> message;

        private HasMessage(Object message) {
            this((Matcher<Object>)new IsEqual(message));
        }

        private HasMessage(Matcher<Object> message) {
            this.message = message;
        }

        public boolean matches(Object arg) {
            return arg instanceof WriteRequest && this.message.matches(((WriteRequest)arg).getMessage());
        }

        public void describeTo(Description description) {
            description.appendText("has message ").appendValue(this.message);
        }
    }
}

