/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.bridge;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.kaazing.gateway.transport.bridge.Message;
import org.kaazing.mina.core.buffer.AbstractIoBufferEx;

public abstract class MessageBuffer<T extends Message>
extends AbstractIoBufferEx {
    private ByteBuffer buf;
    private AtomicReference<T> message;
    private volatile boolean autoCache;

    protected MessageBuffer(ByteBuffer buf) {
        super(buf.capacity());
        this.buf = buf;
        this.message = new AtomicReference();
    }

    protected MessageBuffer(MessageBuffer<T> parent, ByteBuffer buf) {
        super(parent);
        this.buf = buf;
        this.message = new AtomicReference();
    }

    public boolean setMessage(T newMessage) {
        return this.message.compareAndSet(null, newMessage);
    }

    public T getMessage() {
        return (T)((Message)this.message.get());
    }

    public ByteBuffer buf() {
        return this.buf;
    }

    protected void buf(ByteBuffer buf) {
        this.buf = buf;
    }

    protected MessageBuffer<T> duplicate0() {
        return this.create0(this, this.buf.duplicate());
    }

    protected MessageBuffer<T> slice0() {
        return this.create0(this, this.buf.slice());
    }

    protected MessageBuffer<T> asReadOnlyBuffer0() {
        return this.create0(this, this.buf.asReadOnlyBuffer());
    }

    protected abstract MessageBuffer<T> create0(MessageBuffer<T> var1, ByteBuffer var2);

    public byte[] array() {
        return this.buf.array();
    }

    public int arrayOffset() {
        return this.buf.arrayOffset();
    }

    public boolean hasArray() {
        return this.buf.hasArray();
    }

    public void free() {
    }

    public void setAutoCache(boolean autoCache) {
        this.autoCache = autoCache;
    }

    public boolean isAutoCache() {
        return this.autoCache;
    }
}

