/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import java.net.URI;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;
import org.kaazing.gateway.resource.address.Comparators;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.transport.Bindings;

public class NextProtocolBindings
extends Bindings<NextProtocolBinding> {
    public NextProtocolBindings() {
        super(Comparators.compareResourceLocationAndTransportProtocolStack());
    }

    public NextProtocolBindings(Comparator<ResourceAddress> comparator) {
        super(comparator);
    }

    public NextProtocolBinding getProtocolBinding(ResourceAddress bindAddress) {
        return (NextProtocolBinding)super.getBinding0(bindAddress);
    }

    @Override
    public final Bindings.Binding addBinding(Bindings.Binding newBinding) {
        NextProtocolBinding newNextBinding;
        ResourceAddress bindAddress = newBinding.bindAddress();
        NextProtocolBinding nextBinding = (NextProtocolBinding)super.getBinding0(bindAddress);
        if (nextBinding == null && (nextBinding = this.addBinding1(newNextBinding = new NextProtocolBinding(bindAddress))) == null) {
            nextBinding = newNextBinding;
        }
        return nextBinding.addBinding(newBinding);
    }

    protected NextProtocolBinding addBinding1(NextProtocolBinding newNextBinding) {
        return super.addBinding0(newNextBinding);
    }

    @Override
    public Bindings.Binding getBinding(ResourceAddress address) {
        NextProtocolBinding nextBinding = (NextProtocolBinding)super.getBinding0(address);
        if (nextBinding != null) {
            return nextBinding.getBinding(address);
        }
        return null;
    }

    @Override
    public final boolean removeBinding(ResourceAddress address, Bindings.Binding oldBinding) {
        NextProtocolBinding nextBinding = (NextProtocolBinding)super.getBinding0(address);
        if (nextBinding != null && nextBinding.removeBinding(address, oldBinding) && nextBinding.getNextProtocolNames().size() == 0) {
            this.removeBinding1(address, nextBinding);
            return true;
        }
        return false;
    }

    protected void removeBinding1(ResourceAddress address, NextProtocolBinding binding) {
        super.removeBinding0(address, binding);
    }

    @Override
    public String toString() {
        Set entries = this.entrySet();
        if (entries.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        if (!entries.isEmpty()) {
            for (Map.Entry entry : entries) {
                ResourceAddress key = entry.getKey();
                NextProtocolBinding value = (NextProtocolBinding)entry.getValue();
                URI location = key.getResource();
                sb.append("  ").append('[').append(location.resolve("/")).append(']');
                sb.append(" = ");
                sb.append(value);
                sb.append(',').append('\n');
            }
            sb.setLength(sb.length() - 2);
        }
        return sb.append("\n}").toString();
    }

    public class NextProtocolBinding
    extends Bindings.Binding {
        private final ConcurrentNavigableMap<String, Bindings.Binding> nextProtocols;
        private final AtomicReference<Bindings.Binding> nullNextProtocol;

        NextProtocolBinding(ResourceAddress bindAddress) {
            super(bindAddress);
            this.nextProtocols = new ConcurrentSkipListMap<String, Bindings.Binding>();
            this.nullNextProtocol = new AtomicReference();
        }

        public Bindings.Binding addBinding(Bindings.Binding newBinding) {
            ResourceAddress bindAddress = newBinding.bindAddress();
            String nextProtocol = (String)bindAddress.getOption(ResourceAddress.NEXT_PROTOCOL);
            if (nextProtocol == null) {
                if (this.nullNextProtocol.compareAndSet(null, newBinding)) {
                    newBinding.incrementReferenceCount();
                    return null;
                }
                Bindings.Binding oldBinding = this.nullNextProtocol.get();
                if (NextProtocolBindings.this.equivalent(newBinding, oldBinding)) {
                    oldBinding.incrementReferenceCount();
                    return null;
                }
                return oldBinding;
            }
            Bindings.Binding oldBinding = this.nextProtocols.putIfAbsent(nextProtocol, newBinding);
            if (oldBinding == null) {
                newBinding.incrementReferenceCount();
            } else if (NextProtocolBindings.this.equivalent(newBinding, oldBinding)) {
                oldBinding.incrementReferenceCount();
                oldBinding = null;
            }
            return oldBinding;
        }

        public Bindings.Binding getBinding(ResourceAddress address) {
            String nextProtocol = (String)address.getOption(ResourceAddress.NEXT_PROTOCOL);
            if (nextProtocol == null) {
                return this.nullNextProtocol.get();
            }
            return (Bindings.Binding)this.nextProtocols.get(nextProtocol);
        }

        public boolean removeBinding(ResourceAddress address, Bindings.Binding binding) {
            ResourceAddress bindAddress = binding.bindAddress();
            String nextProtocol = (String)bindAddress.getOption(ResourceAddress.NEXT_PROTOCOL);
            if (nextProtocol == null) {
                Bindings.Binding oldBinding = this.nullNextProtocol.get();
                if (NextProtocolBindings.this.equivalent(oldBinding, binding)) {
                    binding = oldBinding;
                }
                if (binding.decrementReferenceCount() == 0) {
                    return this.nullNextProtocol.compareAndSet(binding, null);
                }
                return false;
            }
            Bindings.Binding oldBinding = (Bindings.Binding)this.nextProtocols.get(nextProtocol);
            if (NextProtocolBindings.this.equivalent(oldBinding, binding)) {
                binding = oldBinding;
            }
            if (binding.decrementReferenceCount() == 0) {
                return this.nextProtocols.remove(nextProtocol, binding);
            }
            return false;
        }

        public boolean hasNullNextProtocol() {
            return this.nullNextProtocol.get() != null;
        }

        public SortedSet<String> getNextProtocolNames() {
            return this.nextProtocols.keySet();
        }

        @Override
        public int hashCode() {
            int hashCode = super.hashCode();
            hashCode = hashCode * 31 + this.nextProtocols.hashCode();
            hashCode = hashCode * 31 + this.nullNextProtocol.hashCode();
            return hashCode;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NextProtocolBinding)) {
                return false;
            }
            NextProtocolBinding that = (NextProtocolBinding)o;
            return this.equals(that);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            int mark = sb.length();
            Bindings.Binding nullNextProtocolSnapshot = this.nullNextProtocol.get();
            if (nullNextProtocolSnapshot != null) {
                sb.append("null: ");
                ResourceAddress bindAddress = nullNextProtocolSnapshot.bindAddress();
                sb.append(bindAddress);
                sb.append(", ");
            }
            for (Bindings.Binding binding : this.nextProtocols.values()) {
                ResourceAddress bindAddress = binding.bindAddress();
                sb.append(bindAddress);
                sb.append(", ");
            }
            if (sb.length() > mark) {
                sb.setLength(sb.length() - 2);
            }
            sb.append('}');
            return sb.toString();
        }

        protected final boolean equals(NextProtocolBinding that) {
            return this.nullNextProtocol.equals(that.nullNextProtocol) && this.nextProtocols.equals(that.nextProtocols) && super.equals(that);
        }
    }
}

