/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.transport.LoggingFilter;
import org.kaazing.mina.filter.codec.ProtocolCodecFilter;
import org.slf4j.Logger;

public class ObjectLoggingFilter
extends LoggingFilter {
    public ObjectLoggingFilter(Logger logger, String format) {
        super(logger, format);
    }

    @Override
    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        super.sessionOpened(nextFilter, session);
        IoFilterChain filterChain = session.getFilterChain();
        IoFilterChain.Entry codecEntry = filterChain.getEntry(ProtocolCodecFilter.class);
        if (codecEntry != null) {
            IoFilterChain.Entry loggingEntry = filterChain.getEntry((IoFilter)this);
            assert (loggingEntry != null);
            loggingEntry.remove();
            codecEntry.addAfter(loggingEntry.getName(), loggingEntry.getFilter());
        }
    }

    public static void moveAfterCodec(IoSession session) {
        IoFilterChain filterChain = session.getFilterChain();
        IoFilterChain.Entry loggingEntry = filterChain.getEntry(ObjectLoggingFilter.class);
        if (loggingEntry == null) {
            return;
        }
        IoFilterChain.Entry codecEntry = filterChain.getEntry(ProtocolCodecFilter.class);
        if (codecEntry != null) {
            loggingEntry.remove();
            codecEntry.addAfter(loggingEntry.getName(), loggingEntry.getFilter());
        }
    }
}

