/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.filter.logging.LogLevel;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.ExceptionLoggingFilter;
import org.kaazing.gateway.transport.ObjectLoggingFilter;
import org.kaazing.gateway.transport.bridge.Message;
import org.kaazing.gateway.util.Utils;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;

public class LoggingFilter
extends IoFilterAdapter {
    private final Logger logger;
    private final String format;
    private final String createdFormat;
    private final String openedFormat;
    private final String receivedFormat;
    private final String sentFormat;
    private final String idleFormat;
    private final String exceptionFormat;
    private final String closedFormat;
    private final String writeFormat;

    public LoggingFilter(Logger logger) {
        this(logger, "%s");
    }

    public LoggingFilter(Logger logger, String format) {
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        this.logger = logger;
        this.format = format;
        this.createdFormat = String.format("[%s] CREATED: {}", String.format(format, "{}"));
        this.openedFormat = String.format("[%s] OPENED: {}", String.format(format, "{}"));
        this.receivedFormat = String.format("[%s] RECEIVED: {}", String.format(format, "{}", "{}"));
        this.sentFormat = String.format("[%s] SENT: {}", String.format(format, "{}", "{}"));
        this.idleFormat = String.format("[%s] IDLE", String.format(format, "{}"));
        this.exceptionFormat = String.format("[%s] EXCEPTION: %s", String.format(format, "%s"), "%s");
        this.closedFormat = String.format("[%s] CLOSED: {}", String.format(format, "{}"));
        this.writeFormat = String.format("[%s] WRITE: {}", String.format(format, "{}", "{}"));
    }

    public static boolean addIfNeeded(Logger logger, IoSession session, String transportName) {
        if (!logger.isWarnEnabled()) {
            return false;
        }
        String user = LoggingFilter.getUserIdentifier(session);
        String loggingFilterName = transportName + "#logging";
        String format = transportName + "#%s";
        if (user != null) {
            format = format + " " + user;
        }
        if (logger.isTraceEnabled()) {
            session.getFilterChain().addLast(loggingFilterName, (IoFilter)new ObjectLoggingFilter(logger, format));
            return true;
        }
        session.getFilterChain().addLast(loggingFilterName, (IoFilter)new ExceptionLoggingFilter(logger, format));
        return true;
    }

    public LogLevel getLevel() {
        LogLevel level = LogLevel.ERROR;
        if (this.logger.isTraceEnabled()) {
            level = LogLevel.TRACE;
        } else if (this.logger.isDebugEnabled()) {
            level = LogLevel.DEBUG;
        } else if (this.logger.isInfoEnabled()) {
            level = LogLevel.INFO;
        } else if (this.logger.isWarnEnabled()) {
            level = LogLevel.WARN;
        }
        return level;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getFormat() {
        return this.format;
    }

    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.logSessionCreated(session);
        super.sessionCreated(nextFilter, session);
        IoFilterChain filterChain = session.getFilterChain();
        IoFilterChain.Entry entry = filterChain.getEntry((IoFilter)this);
        if (entry != null) {
            entry.remove();
            filterChain.addLast(entry.getName(), entry.getFilter());
        }
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.logSessionOpened(session);
        super.sessionOpened(nextFilter, session);
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        this.logMessageReceived(session, message);
        super.messageReceived(nextFilter, session, message);
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        this.logMessageSent(session, writeRequest.getMessage());
        super.messageSent(nextFilter, session, writeRequest);
    }

    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
        this.logSessionIdle(session);
        super.sessionIdle(nextFilter, session, status);
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
        this.logExceptionCaught(session, cause);
        super.exceptionCaught(nextFilter, session, cause);
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.logSessionClosed(session);
        super.sessionClosed(nextFilter, session);
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        this.logFilterWrite(session, writeRequest.getMessage());
        super.filterWrite(nextFilter, session, writeRequest);
    }

    protected Strategy getSessionCreatedStrategy() {
        return Strategy.NONE;
    }

    protected Strategy getSessionOpenedStrategy() {
        return Strategy.INFO;
    }

    protected Strategy getMessageReceivedStrategy() {
        return Strategy.TRACE;
    }

    protected Strategy getMessageSentStrategy() {
        return Strategy.TRACE;
    }

    protected Strategy getSessionIdleStrategy() {
        return Strategy.TRACE;
    }

    protected Strategy getExceptionCaughtStrategy(Throwable exception) {
        return LoggingFilter.shouldIncludeStackTrace(exception) ? Strategy.INFO : Strategy.INFO;
    }

    protected Strategy getSessionClosedStrategy() {
        return Strategy.INFO;
    }

    protected Strategy getFilterWriteStrategy() {
        return Strategy.TRACE;
    }

    protected void logSessionCreated(IoSession session) {
        this.getSessionCreatedStrategy().log(this.logger, this.createdFormat, session.getId(), session);
    }

    protected void logSessionOpened(IoSession session) {
        this.getSessionOpenedStrategy().log(this.logger, this.openedFormat, session.getId(), session);
    }

    protected void logMessageReceived(IoSession session, Object message) {
        if (this.getMessageReceivedStrategy().shouldLog(this.logger)) {
            if (message instanceof Message) {
                message = ((Message)message).toVerboseString();
            }
            this.getMessageReceivedStrategy().log(this.logger, this.receivedFormat, session.getId(), message);
        }
    }

    protected void logMessageSent(IoSession session, Object message) {
        if (this.getMessageSentStrategy().shouldLog(this.logger)) {
            if (message instanceof Message) {
                message = ((Message)message).toVerboseString();
            }
            this.getMessageSentStrategy().log(this.logger, this.sentFormat, session.getId(), message);
        }
    }

    protected void logSessionIdle(IoSession session) {
        this.getSessionIdleStrategy().log(this.logger, this.idleFormat, session.getId());
    }

    protected void logExceptionCaught(IoSession session, Throwable cause) {
        this.getExceptionCaughtStrategy(cause).log(this.logger, String.format(this.exceptionFormat, session.getId(), cause), cause);
    }

    protected void logSessionClosed(IoSession session) {
        this.getSessionClosedStrategy().log(this.logger, this.closedFormat, session.getId(), session);
    }

    protected void logFilterWrite(IoSession session, Object message) {
        if (this.getFilterWriteStrategy().shouldLog(this.logger)) {
            if (message instanceof Message) {
                message = ((Message)message).toVerboseString();
            }
            this.getFilterWriteStrategy().log(this.logger, this.writeFormat, session.getId(), message);
        }
    }

    static String getUserIdentifier(IoSession session) {
        IoSessionEx parent;
        String userId = null;
        if (InetSocketAddress.class == session.getTransportMetadata().getAddressType()) {
            userId = session.getService() instanceof IoAcceptor ? session.getRemoteAddress().toString() : session.getLocalAddress().toString();
        } else if (session instanceof BridgeSession && (parent = ((BridgeSession)session).getParent()) != null) {
            return LoggingFilter.getUserIdentifier((IoSession)parent);
        }
        return userId;
    }

    private static boolean shouldLog(Logger logger, LogLevel level) {
        switch (level) {
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case ERROR: {
                return logger.isErrorEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case NONE: {
                return false;
            }
            case TRACE: {
                return logger.isTraceEnabled();
            }
            case WARN: {
                return logger.isWarnEnabled();
            }
        }
        return false;
    }

    private static boolean shouldIncludeStackTrace(Throwable throwable) {
        return !(throwable instanceof IOException);
    }

    public static void log(Logger logger, LogLevel eventLevel, String message, Throwable cause) {
        switch (eventLevel) {
            case TRACE: {
                logger.trace(message, cause);
                return;
            }
            case DEBUG: {
                logger.debug(message, cause);
                return;
            }
            case INFO: {
                logger.info(message, cause);
                return;
            }
            case WARN: {
                logger.warn(message, cause);
                return;
            }
            case ERROR: {
                logger.error(message, cause);
                return;
            }
        }
    }

    public static void log(Logger logger, LogLevel eventLevel, String message, Object param) {
        switch (eventLevel) {
            case TRACE: {
                logger.trace(message, param);
                return;
            }
            case DEBUG: {
                logger.debug(message, param);
                return;
            }
            case INFO: {
                logger.info(message, param);
                return;
            }
            case WARN: {
                logger.warn(message, param);
                return;
            }
            case ERROR: {
                logger.error(message, param);
                return;
            }
        }
    }

    public static void log(Logger logger, LogLevel eventLevel, String message, Object param1, Object param2) {
        switch (eventLevel) {
            case TRACE: {
                logger.trace(message, param1, param2);
                return;
            }
            case DEBUG: {
                logger.debug(message, param1, param2);
                return;
            }
            case INFO: {
                logger.info(message, param1, param2);
                return;
            }
            case WARN: {
                logger.warn(message, param1, param2);
                return;
            }
            case ERROR: {
                logger.error(message, param1, param2);
                return;
            }
        }
    }

    public static void log(Logger logger, LogLevel eventLevel, String message, Object param1, Object param2, Object param3) {
        switch (eventLevel) {
            case TRACE: {
                logger.trace(message, new Object[]{param1, param2, param3});
                return;
            }
            case DEBUG: {
                logger.debug(message, new Object[]{param1, param2, param3});
                return;
            }
            case INFO: {
                logger.info(message, new Object[]{param1, param2, param3});
                return;
            }
            case WARN: {
                logger.warn(message, new Object[]{param1, param2, param3});
                return;
            }
            case ERROR: {
                logger.error(message, new Object[]{param1, param2, param3});
                return;
            }
        }
    }

    private static enum Strategy {
        DEBUG(LogLevel.DEBUG),
        ERROR(LogLevel.ERROR),
        INFO(LogLevel.INFO),
        NONE(LogLevel.NONE),
        TRACE(LogLevel.TRACE),
        WARN(LogLevel.WARN);

        final LogLevel level;

        private Strategy(LogLevel level) {
            this.level = level;
        }

        boolean shouldLog(Logger logger) {
            return LoggingFilter.shouldLog(logger, this.level);
        }

        void log(Logger logger, String message, Throwable cause) {
            if (this.shouldLog(logger)) {
                if (LoggingFilter.shouldIncludeStackTrace(cause)) {
                    Utils.log((Logger)logger, (LogLevel)this.level, (String)message, (Throwable)cause);
                } else {
                    Utils.log((Logger)logger, (LogLevel)this.level, (String)message);
                }
            }
        }

        void log(Logger logger, String message, Object param1) {
            if (this.shouldLog(logger)) {
                Utils.log((Logger)logger, (LogLevel)this.level, (String)message, (Object)param1);
            }
        }

        void log(Logger logger, String message, Object param1, Object param2) {
            if (this.shouldLog(logger)) {
                Utils.log((Logger)logger, (LogLevel)this.level, (String)message, (Object)param1, (Object)param2);
            }
        }
    }
}

