/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.transport.AbstractBridgeHandler;
import org.kaazing.gateway.transport.BridgeAcceptor;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.TypedAttributeKey;

public class BridgeAcceptHandler
extends AbstractBridgeHandler {
    public static final TypedAttributeKey<IoHandler> DELEGATE_KEY = new TypedAttributeKey(BridgeAcceptHandler.class, "delegate");
    private final BridgeAcceptor acceptor;

    public BridgeAcceptHandler(BridgeAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    @Override
    protected IoHandler getHandler(IoSession session, boolean throwIfNull) throws Exception {
        IoHandler handler = DELEGATE_KEY.get(session);
        if (handler == null) {
            ResourceAddress localAddress = BridgeSession.LOCAL_ADDRESS.get(session);
            IoHandler ioHandler = handler = localAddress == null ? null : this.acceptor.getHandler(localAddress);
            if (handler != null) {
                DELEGATE_KEY.set(session, handler);
            } else if (throwIfNull) {
                throw new Exception("No handler found for: " + localAddress);
            }
        }
        return handler;
    }
}

