/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.transport.AbstractBridgeService;
import org.kaazing.gateway.transport.AbstractBridgeSession;
import org.kaazing.gateway.transport.Bindings;
import org.kaazing.gateway.transport.BridgeAcceptHandler;
import org.kaazing.gateway.transport.BridgeAcceptProcessor;
import org.kaazing.gateway.transport.BridgeAcceptor;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.BridgeSessionInitializer;
import org.kaazing.mina.core.future.DefaultUnbindFuture;
import org.kaazing.mina.core.future.UnbindFuture;
import org.kaazing.mina.core.service.IoProcessorEx;
import org.kaazing.mina.core.session.IoSessionConfigEx;

public abstract class AbstractBridgeAcceptor<T extends AbstractBridgeSession<?, ?>, B extends Bindings.Binding>
extends AbstractBridgeService<T>
implements BridgeAcceptor {
    protected final Bindings<B> bindings = this.initBindings();
    protected final AtomicBoolean started = new AtomicBoolean(false);

    public AbstractBridgeAcceptor(IoSessionConfigEx sessionConfig) {
        super(sessionConfig);
    }

    public boolean emptyBindings() {
        return this.bindings.isEmpty();
    }

    protected abstract Bindings<B> initBindings();

    @Override
    public IoHandler getHandler(ResourceAddress address) {
        Bindings.Binding binding = this.bindings.getBinding(address);
        if (binding != null) {
            return binding.handler();
        }
        System.out.println(String.format("ERROR in getHandler: bindings: %s\naddress: %s", this.bindings, address));
        return null;
    }

    protected IoSessionInitializer<?> getInitializer(ResourceAddress address) {
        Bindings.Binding binding = this.bindings.getBinding(address);
        if (binding != null) {
            return binding.initializer();
        }
        return null;
    }

    @Override
    protected IoProcessorEx<T> initProcessor() {
        return new BridgeAcceptProcessor();
    }

    @Override
    protected IoHandler initHandler() {
        return new BridgeAcceptHandler(this);
    }

    protected abstract boolean canBind(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(ResourceAddress address, IoHandler handler, BridgeSessionInitializer<? extends IoFuture> initializer) {
        boolean bindAlternate;
        URI location = address.getResource();
        String schemeName = location.getScheme();
        if (!this.canBind(schemeName)) {
            throw new IllegalArgumentException(String.format("Unexpected scheme \"%s\" for URI: %s", schemeName, location));
        }
        if (!this.started.get()) {
            AtomicBoolean atomicBoolean = this.started;
            synchronized (atomicBoolean) {
                if (!this.started.get()) {
                    this.init();
                    this.started.set(true);
                }
            }
        }
        do {
            bindAlternate = (Boolean)address.getOption(ResourceAddress.BIND_ALTERNATE);
            Bindings.Binding newBinding = new Bindings.Binding(address, handler, initializer);
            Bindings.Binding oldBinding = this.bindings.addBinding(newBinding);
            if (oldBinding != null) {
                throw new RuntimeException("Unable to bind address " + address + " because it collides with an already bound address " + oldBinding.bindAddress());
            }
            this.bindInternal(address, handler, initializer);
        } while ((address = (ResourceAddress)address.getOption(ResourceAddress.ALTERNATE)) != null && bindAlternate);
    }

    protected abstract <F extends IoFuture> void bindInternal(ResourceAddress var1, IoHandler var2, BridgeSessionInitializer<F> var3);

    @Override
    public final UnbindFuture unbind(ResourceAddress address) {
        boolean unbindAlternate;
        UnbindFuture future = null;
        do {
            unbindAlternate = (Boolean)address.getOption(ResourceAddress.BIND_ALTERNATE);
            Bindings.Binding binding = this.bindings.getBinding(address);
            this.bindings.removeBinding(address, binding);
            UnbindFuture newFuture = this.unbindInternal(address, binding.handler(), binding.initializer());
            future = future != null ? DefaultUnbindFuture.combineFutures((UnbindFuture)future, (UnbindFuture)newFuture) : newFuture;
        } while ((address = (ResourceAddress)address.getOption(ResourceAddress.ALTERNATE)) != null && unbindAlternate);
        return future;
    }

    protected abstract UnbindFuture unbindInternal(ResourceAddress var1, IoHandler var2, BridgeSessionInitializer<? extends IoFuture> var3);

    protected void finishSessionInitialization0(IoSession session, IoFuture future) {
        ResourceAddress address = BridgeSession.LOCAL_ADDRESS.get(session);
        IoSessionInitializer<?> initializer = this.getInitializer(address);
        if (initializer != null) {
            initializer.initializeSession(session, future);
        }
    }
}

