/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.bridge;

import java.util.concurrent.ConcurrentMap;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.bridge.Message;
import org.kaazing.gateway.transport.bridge.MessageBuffer;
import org.kaazing.gateway.transport.bridge.MessageEncoder;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.session.IoSessionEx;

public abstract class CachingMessageEncoder {
    public static final CachingMessageEncoder IO_MESSAGE_ENCODER = new CachingMessageEncoder(){

        @Override
        public <T extends Message> IoBufferEx encode(MessageEncoder<T> encoder, T message, IoBufferAllocatorEx<?> allocator, int flags) {
            return this.encode("io", encoder, message, allocator, flags);
        }
    };

    public abstract <T extends Message> IoBufferEx encode(MessageEncoder<T> var1, T var2, IoBufferAllocatorEx<?> var3, int var4);

    protected final <T extends Message> IoBufferEx encode(String cacheKey, MessageEncoder<T> encoder, T message, IoBufferAllocatorEx<?> allocator, int flags) {
        ConcurrentMap<String, IoBufferEx> cache = message.getCache();
        if (cache == null) {
            throw new IllegalStateException("Cache not initialized");
        }
        IoBufferEx cachedBuffer = (IoBufferEx)cache.get(cacheKey);
        if (cachedBuffer == null) {
            IoBufferEx newCachedBuffer;
            if ((flags & 8) != 0 && !cache.isEmpty()) {
                flags &= 0xFFFFFFF7;
            }
            if ((newCachedBuffer = encoder.encode(allocator, message, flags)) instanceof MessageBuffer) {
                MessageBuffer cacheableBuffer = (MessageBuffer)newCachedBuffer;
                cacheableBuffer.setAutoCache(true);
            }
            if ((cachedBuffer = cache.putIfAbsent(cacheKey, newCachedBuffer)) == null) {
                cachedBuffer = newCachedBuffer;
            }
        }
        return cachedBuffer;
    }

    public static CachingMessageEncoder getMessageEncoder(IoSessionEx session) {
        return session instanceof BridgeSession ? ((BridgeSession)session).getMessageEncoder() : IO_MESSAGE_ENCODER;
    }
}

