/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import java.net.SocketAddress;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestQueue;
import org.kaazing.gateway.transport.AbstractBridgeSession;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.service.AbstractIoProcessor;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBridgeProcessor<T extends AbstractBridgeSession<?, ?>>
extends AbstractIoProcessor<T> {
    private final ConcurrentHashMap<SocketAddress, IoSession> sessionMap = new ConcurrentHashMap();
    private final AtomicBoolean disposed = new AtomicBoolean();
    private static final Logger logger = LoggerFactory.getLogger(AbstractBridgeProcessor.class);

    protected void add0(T session) {
        SocketAddress clientAddress = this.getUniqueAddress(session);
        this.sessionMap.putIfAbsent(clientAddress, (IoSession)session);
    }

    protected abstract SocketAddress getUniqueAddress(T var1);

    public IoSession get(SocketAddress clientAddress) {
        return this.sessionMap.get(clientAddress);
    }

    protected final void remove0(T session) {
        this.sessionMap.remove(this.getUniqueAddress(session));
        try {
            this.removeInternal(session);
        }
        finally {
            ((AbstractBridgeSession)session).getService().getListeners().fireSessionDestroyed(session);
        }
    }

    protected void doFireSessionDestroyed(T session) {
    }

    protected void removeInternal(T session) {
        IoSessionEx parent = ((AbstractBridgeSession)session).getParent();
        if (parent != null && !parent.isClosing()) {
            parent.close(false);
        }
    }

    protected final void flush0(T session) {
        this.flushInternal(session);
    }

    protected void flushInternal(T session) {
        WriteRequest request;
        IoSessionEx parent = ((AbstractBridgeSession)session).getParent();
        if (parent == null) {
            return;
        }
        IoFilterChain filterChain = session.getFilterChain();
        WriteRequestQueue writeRequestQueue = session.getWriteRequestQueue();
        while ((request = writeRequestQueue.poll(session)) != null) {
            Object message = this.getMessageFromWriteRequest(session, request);
            if (message instanceof IoBufferEx) {
                IoBufferEx buf = (IoBufferEx)message;
                try {
                    int remaining = buf.remaining();
                    if (remaining == 0) {
                        throw new IllegalStateException("Unexpected empty buffer");
                    }
                    if (parent.isClosing()) {
                        LinkedList<WriteRequest> unwritten = new LinkedList<WriteRequest>();
                        while (request != null) {
                            unwritten.add(request);
                            request = writeRequestQueue.poll(session);
                        }
                        break;
                    }
                    WriteFuture flushFuture = this.flushNow(session, parent, buf, filterChain, request);
                    if (flushFuture == null) break;
                    int written = remaining;
                    if (!this.shouldAccountForWrittenBytes(session)) continue;
                    session.increaseWrittenBytes(written, System.currentTimeMillis());
                }
                catch (Exception e) {
                    request.getFuture().setException((Throwable)e);
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Exception while writing message buffer '%s'.", buf), (Throwable)e);
                        continue;
                    }
                    logger.debug(String.format("Exception while writing message buffer '%s'.", buf));
                }
                continue;
            }
            throw new IllegalStateException("Don't know how to handle message of type '" + message.getClass().getName() + "'.  Are you missing a protocol encoder?");
        }
    }

    protected Object getMessageFromWriteRequest(T session, WriteRequest request) {
        return request.getMessage();
    }

    protected boolean shouldAccountForWrittenBytes(T session) {
        return true;
    }

    protected WriteFuture flushNow(T session, IoSessionEx parent, IoBufferEx buf, IoFilterChain filterChain, WriteRequest request) {
        IoBufferAllocatorEx parentAllocator = parent.getBufferAllocator();
        IoBufferEx parentBuf = parentAllocator.wrap(buf.buf(), buf.flags());
        return AbstractBridgeProcessor.flushNowInternal(parent, parentBuf, buf, filterChain, request);
    }

    protected static WriteFuture flushNowInternal(IoSessionEx parent, Object message, IoBufferEx resetBuf, IoFilterChain filterChain, WriteRequest request) {
        WriteFuture parentFuture = parent.write(message);
        AbstractBridgeProcessor.attachMessageSentInternal(filterChain, resetBuf, request, parentFuture);
        return parentFuture;
    }

    private static void setFutureWritten(IoFilterChain filterChain, WriteFuture future) {
        try {
            future.setWritten();
        }
        catch (Throwable t) {
            filterChain.fireExceptionCaught(t);
        }
    }

    private static void attachMessageSentInternal(final IoFilterChain filterChain, final IoBufferEx resetBuf, final WriteRequest request, WriteFuture future) {
        if (future.isDone()) {
            if (future.isWritten()) {
                resetBuf.reset();
                AbstractBridgeProcessor.setFutureWritten(filterChain, request.getFuture());
            } else {
                request.getFuture().setException(future.getException());
            }
        } else {
            future.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                public void operationComplete(WriteFuture parentFuture) {
                    if (parentFuture.isWritten()) {
                        resetBuf.reset();
                        AbstractBridgeProcessor.setFutureWritten(filterChain, request.getFuture());
                    } else {
                        request.getFuture().setException(parentFuture.getException());
                    }
                }
            });
        }
    }

    public void dispose() {
        if (!this.disposed.compareAndSet(false, true)) {
            throw new IllegalStateException("Already disposed");
        }
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }

    public boolean isDisposing() {
        return this.disposed.get();
    }

    protected final void updateTrafficControl0(T session) {
        if (!session.isWriteSuspended()) {
            this.flush((IoSessionEx)session);
        }
        if (!session.isReadSuspended()) {
            this.consume(session);
        }
    }

    protected void consume(T session) {
    }
}

