/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.gateway.transport.TypedAttributeKey;

public abstract class AbstractInboundEventFilter
extends IoFilterAdapter {
    private final TypedAttributeKey<Queue<InboundEvent>> inboundEventsKey = new TypedAttributeKey(((Object)((Object)this)).getClass(), "inboundEvents");

    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        Queue<InboundEvent> inboundEvents = this.inboundEventsKey.get(session);
        if (inboundEvents != null) {
            inboundEvents.add(new SessionCreatedEvent());
        } else {
            super.sessionCreated(nextFilter, session);
        }
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        Queue<InboundEvent> inboundEvents = this.inboundEventsKey.get(session);
        if (inboundEvents != null) {
            inboundEvents.add(new SessionOpenedEvent());
        } else {
            super.sessionOpened(nextFilter, session);
        }
    }

    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
        super.sessionIdle(nextFilter, session, status);
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
        super.exceptionCaught(nextFilter, session, cause);
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        Queue<InboundEvent> inboundEvents = this.inboundEventsKey.get(session);
        if (inboundEvents != null) {
            inboundEvents.add(new MessageReceivedEvent(message));
        } else {
            super.messageReceived(nextFilter, session, message);
        }
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        Queue<InboundEvent> inboundEvents = this.inboundEventsKey.get(session);
        if (inboundEvents != null) {
            inboundEvents.add(new MessageSentEvent(writeRequest));
        } else {
            super.messageSent(nextFilter, session, writeRequest);
        }
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        Queue<InboundEvent> inboundEvents = this.inboundEventsKey.get(session);
        if (inboundEvents != null) {
            inboundEvents.add(new SessionClosedEvent());
        } else {
            super.sessionClosed(nextFilter, session);
        }
    }

    protected Queue<InboundEvent> suspendInboundEvents(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        ConcurrentLinkedQueue newInboundEvents;
        ConcurrentLinkedQueue inboundEvents = this.inboundEventsKey.get(session);
        if (inboundEvents == null && (inboundEvents = (ConcurrentLinkedQueue)this.inboundEventsKey.setIfAbsent(session, newInboundEvents = new ConcurrentLinkedQueue())) == null) {
            inboundEvents = newInboundEvents;
        }
        return inboundEvents;
    }

    protected void flushInboundEvents(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        Queue<InboundEvent> inboundEvents = this.inboundEventsKey.remove(session);
        if (inboundEvents != null) {
            for (InboundEvent inboundEvent : inboundEvents) {
                inboundEvent.flush(nextFilter, session);
            }
        }
    }

    private static final class SessionClosedEvent
    extends InboundEvent {
        private SessionClosedEvent() {
        }

        @Override
        public void flush(IoFilter.NextFilter nextFilter, IoSession session) {
            nextFilter.sessionClosed(session);
        }
    }

    private static final class MessageSentEvent
    extends InboundEvent {
        private final WriteRequest writeRequest;

        public MessageSentEvent(WriteRequest writeRequest) {
            this.writeRequest = writeRequest;
        }

        @Override
        public void flush(IoFilter.NextFilter nextFilter, IoSession session) {
            nextFilter.messageSent(session, this.writeRequest);
        }
    }

    private static final class MessageReceivedEvent
    extends InboundEvent {
        private final Object message;

        public MessageReceivedEvent(Object message) {
            this.message = message;
        }

        @Override
        public void flush(IoFilter.NextFilter nextFilter, IoSession session) {
            nextFilter.messageReceived(session, this.message);
        }
    }

    private static final class SessionOpenedEvent
    extends InboundEvent {
        private SessionOpenedEvent() {
        }

        @Override
        public void flush(IoFilter.NextFilter nextFilter, IoSession session) {
            nextFilter.sessionOpened(session);
        }
    }

    private static final class SessionCreatedEvent
    extends InboundEvent {
        private SessionCreatedEvent() {
        }

        @Override
        public void flush(IoFilter.NextFilter nextFilter, IoSession session) {
            nextFilter.sessionCreated(session);
        }
    }

    private static abstract class InboundEvent {
        private InboundEvent() {
        }

        public abstract void flush(IoFilter.NextFilter var1, IoSession var2);
    }
}

