/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionConfig;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.transport.BridgeAcceptor;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.DefaultIoSessionConfigEx;
import org.kaazing.gateway.transport.Direction;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.service.IoProcessorEx;
import org.kaazing.mina.core.service.IoServiceEx;
import org.kaazing.mina.core.session.AbstractIoSessionConfigEx;
import org.kaazing.mina.core.session.AbstractIoSessionEx;
import org.kaazing.mina.core.session.IoSessionConfigEx;
import org.kaazing.mina.core.session.IoSessionEx;

public abstract class AbstractBridgeSession<S extends IoSessionEx, B extends IoBufferEx>
extends AbstractIoSessionEx
implements BridgeSession {
    private final IoProcessorEx<S> processor;
    private final IoSessionConfigEx sessionConfig;
    private final ResourceAddress localAddress;
    private final ResourceAddress remoteAddress;
    private final IoServiceEx service;
    private final TransportMetadata metadata;
    private final IoBufferAllocatorEx<? extends B> allocator;
    private final AtomicReference<IoSessionEx> parent;
    private volatile Direction direction;
    private IoHandler handler;

    public AbstractBridgeSession(int parentIoLayer, Thread parentIoThread, Executor parentIoExecutor, IoServiceEx service, IoProcessorEx<S> sIoProcessor, ResourceAddress localAddress, ResourceAddress remoteAddress, IoBufferAllocatorEx<? extends B> allocator, Direction direction) {
        this(parentIoLayer, parentIoThread, parentIoExecutor, service, sIoProcessor, localAddress, remoteAddress, null, allocator, direction, (IoSessionConfigEx)new DefaultIoSessionConfigEx());
    }

    public AbstractBridgeSession(int parentIoLayer, Thread parentIoThread, Executor parentIoExecutor, IoServiceEx service, IoProcessorEx<S> sIoProcessor, ResourceAddress localAddress, ResourceAddress remoteAddress, IoBufferAllocatorEx<? extends B> allocator, Direction direction, IoSessionConfigEx config) {
        this(parentIoLayer + 1, parentIoThread, parentIoExecutor, service, sIoProcessor, localAddress, remoteAddress, null, allocator, direction, config);
    }

    public AbstractBridgeSession(IoServiceEx service, IoProcessorEx<S> processor, ResourceAddress localAddress, ResourceAddress remoteAddress, IoSessionEx parent, IoBufferAllocatorEx<? extends B> allocator, Direction direction) {
        this(service, processor, localAddress, remoteAddress, parent, allocator, direction, (IoSessionConfigEx)new DefaultIoSessionConfigEx());
    }

    public AbstractBridgeSession(IoServiceEx service, IoProcessorEx<S> processor, ResourceAddress localAddress, ResourceAddress remoteAddress, IoSessionEx parent, IoBufferAllocatorEx<? extends B> allocator, Direction direction, IoSessionConfigEx config) {
        this(AbstractBridgeSession.checkParentNotNull(parent).getIoLayer() + 1, parent.getIoThread(), parent.getIoExecutor(), service, processor, localAddress, remoteAddress, parent, allocator, direction, config);
    }

    private AbstractBridgeSession(int ioLayer, Thread ioThread, Executor ioExecutor, IoServiceEx service, IoProcessorEx<S> processor, ResourceAddress localAddress, ResourceAddress remoteAddress, IoSessionEx parent, IoBufferAllocatorEx<? extends B> allocator, Direction direction, IoSessionConfigEx config) {
        super(ioLayer, ioThread, ioExecutor, service.getThreadLocalWriteRequest(ioLayer));
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        this.service = service;
        this.processor = processor;
        this.parent = new AtomicReference<IoSessionEx>(parent);
        this.allocator = allocator;
        this.metadata = service.getTransportMetadata();
        this.handler = service.getHandler();
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        config.setAll((IoSessionConfig)service.getSessionConfig());
        this.sessionConfig = config.getClass() == DefaultIoSessionConfigEx.class ? new BridgeSessionConfigEx(config) : config;
        this.direction = direction;
    }

    public final IoBufferAllocatorEx<? extends B> getBufferAllocator() {
        return this.allocator;
    }

    public IoProcessorEx<S> getProcessor() {
        return this.processor;
    }

    public IoSessionConfigEx getConfig() {
        return this.sessionConfig;
    }

    public IoHandler getHandler() {
        return this.handler;
    }

    public void setHandler(IoHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.handler = handler;
    }

    @Override
    public ResourceAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public ResourceAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public IoServiceEx getService() {
        return this.service;
    }

    public TransportMetadata getTransportMetadata() {
        return this.metadata;
    }

    @Override
    public IoSessionEx getParent() {
        return this.parent.get();
    }

    protected boolean compareAndSetParent(IoSessionEx expectedParent, IoSessionEx newParent) {
        return this.parent.compareAndSet(expectedParent, newParent);
    }

    protected IoSessionEx setParent(IoSessionEx newParent) {
        return this.parent.getAndSet(newParent);
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    public void reset(final Throwable cause) {
        if (cause == null) {
            throw new NullPointerException("cause must not be null in AbstractBridgeSession.reset");
        }
        if (!this.isIoAligned() || this.getIoThread() == Thread.currentThread()) {
            this.reset0(cause);
        } else {
            this.getIoExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    AbstractBridgeSession.this.reset0(cause);
                }
            });
        }
    }

    protected void setIoAlignment0(Thread ioThread, Executor ioExecutor) {
        IoSessionEx parent = this.parent.get();
        if (parent != null) {
            parent.setIoAlignment(ioThread, ioExecutor);
        }
    }

    protected void suspendRead1() {
        this.suspendRead2();
        IoSession parent = (IoSession)this.parent.get();
        if (parent != null) {
            parent.suspendRead();
        }
    }

    protected void suspendRead2() {
        super.suspendRead1();
    }

    protected void resumeRead1() {
        this.resumeRead2();
        IoSession parent = (IoSession)this.parent.get();
        if (parent != null) {
            parent.resumeRead();
        }
    }

    protected void resumeRead2() {
        super.resumeRead1();
    }

    private void reset0(Throwable cause) {
        try {
            this.getFilterChain().fireExceptionCaught(cause);
        }
        finally {
            this.getProcessor().remove((IoSession)this);
        }
    }

    @Deprecated
    public void reset() {
        if (!this.isIoAligned() || this.getIoThread() == Thread.currentThread()) {
            this.reset0();
        } else {
            this.getIoExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    AbstractBridgeSession.this.reset0();
                }
            });
        }
    }

    @Deprecated
    private void reset0() {
        this.getProcessor().remove((IoSession)this);
    }

    protected void setDirection(Direction direction) {
        this.direction = direction;
    }

    public String toString() {
        URI externalRemoteURI = this.getRemoteAddress().getExternalURI();
        URI externalLocalURI = this.getLocalAddress().getExternalURI();
        if (this.getService() instanceof BridgeAcceptor) {
            StringBuilder sb = new StringBuilder();
            sb.append('(').append(this.getIdAsString()).append(": ").append(this.getServiceName());
            sb.append(", server, ").append(externalRemoteURI).append(" => ");
            sb.append(externalLocalURI).append(')');
            String result = sb.toString();
            return result;
        }
        return "(" + this.getIdAsString() + ": " + this.getServiceName() + ", client, " + externalLocalURI + " => " + externalRemoteURI + ')';
    }

    private String getIdAsString() {
        return String.format("#%08d", this.getId());
    }

    private String getServiceName() {
        TransportMetadata tm = this.getTransportMetadata();
        if (tm == null) {
            return "null";
        }
        return tm.getProviderName() + ' ' + tm.getName();
    }

    private static IoSessionEx checkParentNotNull(IoSessionEx parent) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        return parent;
    }

    private class BridgeSessionConfigEx
    extends AbstractIoSessionConfigEx {
        private boolean propagateIdleTime = false;

        BridgeSessionConfigEx(IoSessionConfigEx wrappedConfig) {
            this.setAll((IoSessionConfig)wrappedConfig);
            this.propagateIdleTime = true;
        }

        public void setIdleTime(IdleStatus status, int idleTime) {
            if (this.propagateIdleTime) {
                IoSessionEx parent = (IoSessionEx)AbstractBridgeSession.this.parent.get();
                if (parent != null) {
                    parent.getConfig().setIdleTime(status, idleTime);
                } else {
                    super.setIdleTime(status, idleTime);
                }
            }
        }

        public void setIdleTimeInMillis(IdleStatus status, long idleTimeMillis) {
            IoSessionEx parent;
            if (this.propagateIdleTime && (parent = (IoSessionEx)AbstractBridgeSession.this.parent.get()) != null) {
                IoSessionConfigEx config = parent.getConfig();
                config.setIdleTimeInMillis(status, idleTimeMillis);
            }
        }

        public int getIdleTime(IdleStatus status) {
            IoSessionEx parent = (IoSessionEx)AbstractBridgeSession.this.parent.get();
            if (parent != null) {
                return parent.getConfig().getIdleTime(status);
            }
            return super.getIdleTime(status);
        }

        public long getIdleTimeInMillis(IdleStatus status) {
            IoSessionEx parent = (IoSessionEx)AbstractBridgeSession.this.parent.get();
            if (parent != null) {
                IoSessionConfigEx config = parent.getConfig();
                return config.getIdleTimeInMillis(status);
            }
            return super.getIdleTimeInMillis(status);
        }

        protected void doSetAll(IoSessionConfigEx config) {
        }
    }
}

