/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import java.net.Proxy;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.kaazing.gateway.resource.address.Protocol;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.transport.BridgeAcceptor;
import org.kaazing.gateway.transport.BridgeConnector;
import org.kaazing.gateway.transport.ProxyHandler;
import org.kaazing.gateway.transport.Transport;
import org.kaazing.gateway.transport.TransportFactorySpi;
import org.kaazing.gateway.transport.dispatch.ProtocolDispatcher;

public class TransportFactory {
    private final Map<String, Transport> transportsByName;
    private final Map<String, Transport> transportsBySchemeName;
    private final Map<Proxy.Type, ProxyHandler> proxyHandlersByType;
    private final Map<String, Protocol> protocolsBySchemeName;
    private final Map<String, ProtocolDispatcher> dispatchersByProtocolName;

    private TransportFactory(Map<String, Transport> transportsByName, Map<String, Transport> transportsBySchemeName, Map<Proxy.Type, ProxyHandler> proxyHandlersByType, Map<String, Protocol> protocolsBySchemeName, Map<String, ProtocolDispatcher> dispatchersByProtocolName) {
        this.transportsByName = Collections.unmodifiableMap(transportsByName);
        this.transportsBySchemeName = Collections.unmodifiableMap(transportsBySchemeName);
        this.proxyHandlersByType = Collections.unmodifiableMap(proxyHandlersByType);
        this.protocolsBySchemeName = Collections.unmodifiableMap(protocolsBySchemeName);
        this.dispatchersByProtocolName = Collections.unmodifiableMap(dispatchersByProtocolName);
    }

    public static TransportFactory newTransportFactory(Map<String, ?> configuration) {
        return TransportFactory.newTransportFactory(ServiceLoader.load(TransportFactorySpi.class), configuration);
    }

    public static TransportFactory newTransportFactory(ClassLoader loader, Map<String, ?> configuration) {
        return TransportFactory.newTransportFactory(ServiceLoader.load(TransportFactorySpi.class, loader), configuration);
    }

    public Transport getTransport(String transportName) {
        Transport transport = this.transportsByName.get(transportName);
        if (transport == null) {
            throw new IllegalArgumentException("Unrecognized transport: " + transportName);
        }
        return transport;
    }

    public Transport getTransportForScheme(String schemeName) {
        Transport transport = this.transportsBySchemeName.get(schemeName);
        if (transport == null) {
            throw new IllegalArgumentException("Unrecognized scheme:" + schemeName);
        }
        return transport;
    }

    public Set<String> getTransportNames() {
        return this.transportsByName.keySet();
    }

    private static TransportFactory newTransportFactory(ServiceLoader<TransportFactorySpi> transportFactories, Map<String, ?> configuration) {
        HashMap<String, Transport> transportsByName = new HashMap<String, Transport>();
        HashMap<String, Transport> transportsBySchemeName = new HashMap<String, Transport>();
        HashMap<Proxy.Type, ProxyHandler> proxyHandlersByType = new HashMap<Proxy.Type, ProxyHandler>();
        HashMap<String, Protocol> protocolsBySchemeName = new HashMap<String, Protocol>();
        HashMap<String, ProtocolDispatcher> dispatchersByProtocolName = new HashMap<String, ProtocolDispatcher>();
        for (TransportFactorySpi transportFactory : transportFactories) {
            String transportName = transportFactory.getTransportName();
            if (transportsByName.containsKey(transportName)) {
                throw new RuntimeException(String.format("Duplicate transport name transport factory: %s", transportName));
            }
            Collection<String> schemeNames = transportFactory.getSchemeNames();
            for (String schemeName : schemeNames) {
                if (!transportsBySchemeName.containsKey(schemeName)) continue;
                throw new RuntimeException(String.format("Duplicate scheme name transport factory: %s", transportName));
            }
            Transport transport = transportFactory.newTransport(configuration);
            transportsByName.put(transportName, transport);
            for (String schemeName : schemeNames) {
                transportsBySchemeName.put(schemeName, transport);
            }
            proxyHandlersByType.putAll(transport.getProxyHandlers());
            protocolsBySchemeName.putAll(transport.getProtocols());
            dispatchersByProtocolName.putAll(transport.getProtocolDispatchers());
        }
        return new TransportFactory(transportsByName, transportsBySchemeName, proxyHandlersByType, protocolsBySchemeName, dispatchersByProtocolName);
    }

    public BridgeAcceptor getAcceptor(ResourceAddress address) {
        return this.transportsBySchemeName.get(address.getResource().getScheme()).getAcceptor(address);
    }

    public BridgeConnector getConnector(ResourceAddress address) {
        return this.transportsBySchemeName.get(address.getResource().getScheme()).getConnector(address);
    }

    public Map<Proxy.Type, ProxyHandler> getProxyHandlers() {
        return this.proxyHandlersByType;
    }

    public Protocol getProtocol(URI uri) {
        return this.getProtocol(uri.getScheme());
    }

    public Protocol getProtocol(String scheme) {
        return this.protocolsBySchemeName.get(scheme);
    }

    public Map<String, ProtocolDispatcher> getProtocolDispatchers() {
        return this.dispatchersByProtocolName;
    }

    public ProtocolDispatcher getProtocolDispatcher(String protocolName) {
        return this.dispatchersByProtocolName.get(protocolName);
    }
}

