/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import java.nio.channels.ClosedChannelException;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBridgeHandler
implements IoHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBridgeHandler.class);

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        IoHandler handler;
        if (LOG.isTraceEnabled()) {
            if (session.isClosing() && cause instanceof ClosedChannelException) {
                LOG.trace(String.format("Exception caught in bridge handler, probably because session was closed with pending writes: %s", cause));
            } else {
                LOG.trace("Exception caught in bridge handler", cause);
            }
        }
        if ((handler = this.getHandler(session, false)) != null) {
            handler.exceptionCaught(session, cause);
        } else {
            if (LOG.isDebugEnabled()) {
                String message = String.format("Unable to get handler in bridge handler exceptionCaught while processing exception %s", cause);
                if (LOG.isTraceEnabled()) {
                    LOG.debug(message, cause);
                } else {
                    LOG.debug(message);
                }
            }
            session.close(true);
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        this.getHandler(session).messageReceived(session, message);
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        this.getHandler(session).messageSent(session, message);
    }

    public void sessionClosed(IoSession session) throws Exception {
        this.getHandler(session).sessionClosed(session);
    }

    public void sessionCreated(IoSession session) throws Exception {
        this.getHandler(session).sessionCreated(session);
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        this.getHandler(session).sessionIdle(session, status);
    }

    public void sessionOpened(IoSession session) throws Exception {
        this.getHandler(session).sessionOpened(session);
    }

    protected final IoHandler getHandler(IoSession session) throws Exception {
        return this.getHandler(session, true);
    }

    protected abstract IoHandler getHandler(IoSession var1, boolean var2) throws Exception;
}

