/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.io.filter;

import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.io.filter.IoMessageDecoder;
import org.kaazing.gateway.transport.io.filter.IoMessageEncoder;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.kaazing.mina.filter.codec.ProtocolCodecFilter;

public class IoMessageCodecFilter
extends ProtocolCodecFilter {
    public IoMessageCodecFilter() {
        super((ProtocolCodecFactory)new IoMessageCodecFactory());
    }

    private static class IoMessageCodecFactory
    implements ProtocolCodecFactory {
        private IoMessageCodecFactory() {
        }

        public ProtocolDecoder getDecoder(IoSession session) throws Exception {
            return new IoMessageDecoder();
        }

        public ProtocolEncoder getEncoder(IoSession session) throws Exception {
            IoSessionEx sessionEx = (IoSessionEx)session;
            IoBufferAllocatorEx allocator = sessionEx.getBufferAllocator();
            if (session instanceof BridgeSession) {
                BridgeSession transportSession = (BridgeSession)session;
                return new IoMessageEncoder(transportSession.getMessageEncoder(), allocator);
            }
            return new IoMessageEncoder(allocator);
        }
    }
}

