/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import java.util.Collection;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.transport.AbstractInboundEventFilter;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.dispatch.ProtocolDispatcher;

public class NextProtocolFilter
extends AbstractInboundEventFilter {
    private final Collection<ProtocolDispatcher> dispatchers;

    public NextProtocolFilter(Collection<ProtocolDispatcher> dispatchers) {
        if (dispatchers == null) {
            throw new NullPointerException("dispatchers");
        }
        this.dispatchers = dispatchers;
    }

    @Override
    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        switch (this.dispatchers.size()) {
            case 0: {
                BridgeSession.NEXT_PROTOCOL_KEY.set(session, null);
                session.getFilterChain().remove((IoFilter)this);
                break;
            }
            case 1: {
                ProtocolDispatcher dispatcher = this.dispatchers.iterator().next();
                String protocolName = dispatcher.getProtocolName();
                BridgeSession.NEXT_PROTOCOL_KEY.set(session, protocolName);
                session.getFilterChain().remove((IoFilter)this);
                break;
            }
            default: {
                this.suspendInboundEvents(nextFilter, session);
            }
        }
        super.sessionOpened(nextFilter, session);
    }

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (message instanceof IoBuffer) {
            IoBuffer buffer = (IoBuffer)message;
            int initialByte = buffer.get(buffer.position()) & 0xFF;
            block0: for (ProtocolDispatcher dispatcher : this.dispatchers) {
                Collection<byte[]> discriminators = dispatcher.getDiscriminators();
                for (byte[] discriminator : discriminators) {
                    if (initialByte != discriminator[0]) continue;
                    String protocolName = dispatcher.getProtocolName();
                    BridgeSession.NEXT_PROTOCOL_KEY.set(session, protocolName);
                    break block0;
                }
            }
            this.flushInboundEvents(nextFilter, session);
            session.getFilterChain().remove((IoFilter)this);
        }
        super.messageReceived(nextFilter, session, message);
    }
}

