/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import java.net.SocketAddress;

public class NamedPipeAddress
extends SocketAddress {
    private static final long serialVersionUID = 1L;
    private final String pipeName;
    private final boolean ephemeral;

    public NamedPipeAddress(String pipeName) {
        this(pipeName, false);
    }

    public NamedPipeAddress(String pipeName, boolean ephemeral) {
        if (pipeName == null) {
            throw new NullPointerException("pipeName");
        }
        this.pipeName = pipeName;
        this.ephemeral = ephemeral;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public int hashCode() {
        return this.pipeName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this.ephemeral) {
            return false;
        }
        NamedPipeAddress that = (NamedPipeAddress)obj;
        return this.pipeName.equals(that.pipeName);
    }

    public String toString() {
        return this.ephemeral ? "[ephemeral]" : this.pipeName;
    }
}

