/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.filter.logging.LogLevel;
import org.kaazing.gateway.transport.bridge.Message;
import org.slf4j.Logger;

public class LoggingFilter
extends IoFilterAdapter {
    private final Logger logger;
    private final String format;
    private final String createdFormat;
    private final String openedFormat;
    private final String receivedFormat;
    private final String sentFormat;
    private final String idleFormat;
    private final String exceptionFormat;
    private final String closedFormat;
    private final String writeFormat;

    public LoggingFilter(Logger logger) {
        this(logger, "%s");
    }

    public LoggingFilter(Logger logger, String format) {
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        this.logger = logger;
        this.format = format;
        this.createdFormat = String.format("[%s] CREATED: {}", String.format(format, "{}"));
        this.openedFormat = String.format("[%s] OPENED: {}", String.format(format, "{}"));
        this.receivedFormat = String.format("[%s] RECEIVED: {}: {}", String.format(format, "{}", "{}"));
        this.sentFormat = String.format("[%s] SENT: {}: {}", String.format(format, "{}", "{}"));
        this.idleFormat = String.format("[%s] IDLE: {}", String.format(format, "{}"));
        this.exceptionFormat = String.format("[%s] EXCEPTION: {}: {}", String.format(format, "{}", "{}"));
        this.closedFormat = String.format("[%s] CLOSED: {}", String.format(format, "{}"));
        this.writeFormat = String.format("[%s] WRITE: {}: {}", String.format(format, "{}", "{}"));
    }

    public LogLevel getLevel() {
        LogLevel level = LogLevel.ERROR;
        if (this.logger.isTraceEnabled()) {
            level = LogLevel.TRACE;
        } else if (this.logger.isDebugEnabled()) {
            level = LogLevel.DEBUG;
        } else if (this.logger.isInfoEnabled()) {
            level = LogLevel.INFO;
        } else if (this.logger.isWarnEnabled()) {
            level = LogLevel.WARN;
        }
        return level;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getFormat() {
        return this.format;
    }

    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.logSessionCreated(session);
        super.sessionCreated(nextFilter, session);
        IoFilterChain filterChain = session.getFilterChain();
        IoFilterChain.Entry entry = filterChain.getEntry((IoFilter)this);
        if (entry != null) {
            entry.remove();
            filterChain.addLast(entry.getName(), entry.getFilter());
        }
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.logSessionOpened(session);
        super.sessionOpened(nextFilter, session);
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        this.logMessageReceived(session, message);
        super.messageReceived(nextFilter, session, message);
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        this.logMessageSent(session, writeRequest.getMessage());
        super.messageSent(nextFilter, session, writeRequest);
    }

    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
        this.logSessionIdle(session);
        super.sessionIdle(nextFilter, session, status);
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
        this.logExceptionCaught(session, cause);
        super.exceptionCaught(nextFilter, session, cause);
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.logSessionClosed(session);
        super.sessionClosed(nextFilter, session);
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        this.logFilterWrite(session, writeRequest.getMessage());
        super.filterWrite(nextFilter, session, writeRequest);
    }

    protected boolean shouldLogSessionCreated() {
        return this.logger.isTraceEnabled();
    }

    protected boolean shouldLogSessionOpened() {
        return this.logger.isTraceEnabled();
    }

    protected boolean shouldLogMessageReceived() {
        return this.logger.isTraceEnabled();
    }

    protected boolean shouldLogMessageSent() {
        return this.logger.isTraceEnabled();
    }

    protected boolean shouldLogSessionIdle() {
        return this.logger.isTraceEnabled();
    }

    protected boolean shouldLogExceptionCaught() {
        return this.logger.isTraceEnabled();
    }

    protected boolean shouldLogSessionClosed() {
        return this.logger.isTraceEnabled();
    }

    protected boolean shouldLogFilterWrite() {
        return this.logger.isTraceEnabled();
    }

    protected void logSessionCreated(IoSession session) {
        if (this.shouldLogSessionCreated()) {
            LoggingFilter.log(this.logger, this.getLevel(), this.createdFormat, session.getId(), session);
        }
    }

    protected void logSessionOpened(IoSession session) {
        if (this.shouldLogSessionOpened()) {
            LoggingFilter.log(this.logger, this.getLevel(), this.openedFormat, session.getId(), session);
        }
    }

    protected void logMessageReceived(IoSession session, Object message) {
        if (this.shouldLogMessageReceived()) {
            if (message instanceof Message) {
                message = ((Message)message).toVerboseString();
            }
            LoggingFilter.log(this.logger, this.getLevel(), this.receivedFormat, session.getId(), session, message);
        }
    }

    protected void logMessageSent(IoSession session, Object message) {
        if (this.shouldLogMessageSent()) {
            if (message instanceof Message) {
                message = ((Message)message).toVerboseString();
            }
            LoggingFilter.log(this.logger, this.getLevel(), this.sentFormat, session.getId(), session, message);
        }
    }

    protected void logSessionIdle(IoSession session) {
        if (this.shouldLogSessionIdle()) {
            LoggingFilter.log(this.logger, this.getLevel(), this.idleFormat, session.getId(), session);
        }
    }

    protected void logExceptionCaught(IoSession session, Throwable cause) {
        if (this.shouldLogExceptionCaught()) {
            LoggingFilter.log(this.logger, this.getLevel(), this.exceptionFormat, session.getId(), session, cause);
        }
    }

    protected void logSessionClosed(IoSession session) {
        if (this.shouldLogSessionClosed()) {
            LoggingFilter.log(this.logger, this.getLevel(), this.closedFormat, session.getId(), session);
        }
    }

    protected void logFilterWrite(IoSession session, Object message) {
        if (this.shouldLogFilterWrite()) {
            if (message instanceof Message) {
                message = ((Message)message).toVerboseString();
            }
            LoggingFilter.log(this.logger, this.getLevel(), this.writeFormat, session.getId(), session, message);
        }
    }

    public static final void log(Logger logger, LogLevel eventLevel, String message, Throwable cause) {
        switch (eventLevel) {
            case TRACE: {
                logger.trace(message, cause);
                return;
            }
            case DEBUG: {
                logger.debug(message, cause);
                return;
            }
            case INFO: {
                logger.info(message, cause);
                return;
            }
            case WARN: {
                logger.warn(message, cause);
                return;
            }
            case ERROR: {
                logger.error(message, cause);
                return;
            }
        }
    }

    public static final void log(Logger logger, LogLevel eventLevel, String message, Object param) {
        switch (eventLevel) {
            case TRACE: {
                logger.trace(message, param);
                return;
            }
            case DEBUG: {
                logger.debug(message, param);
                return;
            }
            case INFO: {
                logger.info(message, param);
                return;
            }
            case WARN: {
                logger.warn(message, param);
                return;
            }
            case ERROR: {
                logger.error(message, param);
                return;
            }
        }
    }

    public static final void log(Logger logger, LogLevel eventLevel, String message, Object param1, Object param2) {
        switch (eventLevel) {
            case TRACE: {
                logger.trace(message, param1, param2);
                return;
            }
            case DEBUG: {
                logger.debug(message, param1, param2);
                return;
            }
            case INFO: {
                logger.info(message, param1, param2);
                return;
            }
            case WARN: {
                logger.warn(message, param1, param2);
                return;
            }
            case ERROR: {
                logger.error(message, param1, param2);
                return;
            }
        }
    }

    public static final void log(Logger logger, LogLevel eventLevel, String message, Object param1, Object param2, Object param3) {
        switch (eventLevel) {
            case TRACE: {
                logger.trace(message, new Object[]{param1, param2, param3});
                return;
            }
            case DEBUG: {
                logger.debug(message, new Object[]{param1, param2, param3});
                return;
            }
            case INFO: {
                logger.info(message, new Object[]{param1, param2, param3});
                return;
            }
            case WARN: {
                logger.warn(message, new Object[]{param1, param2, param3});
                return;
            }
            case ERROR: {
                logger.error(message, new Object[]{param1, param2, param3});
                return;
            }
        }
    }
}

