/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.collections;

import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICollection;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.ICondition;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.ItemListener;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.query.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.kaazing.gateway.service.collections.CollectionsFactory;
import org.kaazing.gateway.util.AtomicCounter;

public class MemoryCollectionsFactory
implements CollectionsFactory {
    private static final String OPERATION_NOT_SUPPORTED_MESSAGE = "Operation %s not supported";
    private final ConcurrentMap<String, IMapImpl<?, ?>> maps = new ConcurrentHashMap();
    private final ConcurrentMap<String, IListImpl<?>> lists = new ConcurrentHashMap();
    private final Map<String, ILockImpl> locks = Collections.synchronizedMap(new WeakHashMap());
    private final ConcurrentMap<String, AtomicCounter> atomicCounters = new ConcurrentHashMap<String, AtomicCounter>();

    @Override
    public <E> IList<E> getList(String name) {
        IListImpl newList;
        IListImpl list = (IListImpl)this.lists.get(name);
        if (list == null && (list = this.lists.putIfAbsent(name, newList = new IListImpl(name))) == null) {
            list = newList;
        }
        return list;
    }

    @Override
    public <E> IQueue<E> getQueue(String name) {
        throw new UnsupportedOperationException(String.format(OPERATION_NOT_SUPPORTED_MESSAGE, "getQueue"));
    }

    @Override
    public <E> ITopic<E> getTopic(String name) {
        throw new UnsupportedOperationException(String.format(OPERATION_NOT_SUPPORTED_MESSAGE, "getTopic"));
    }

    @Override
    public <K, V> IMap<K, V> getMap(String name) {
        IMapImpl newMap;
        IMapImpl map = (IMapImpl)this.maps.get(name);
        if (map == null && (map = this.maps.putIfAbsent(name, newMap = new IMapImpl(name))) == null) {
            map = newMap;
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILock getLock(String name) {
        Map<String, ILockImpl> map = this.locks;
        synchronized (map) {
            ILock lock = this.locks.get(name);
            if (lock == null) {
                ILockImpl newLock = new ILockImpl(name);
                this.locks.put(name, newLock);
                lock = newLock;
            }
            assert (lock != null);
            return lock;
        }
    }

    @Override
    public AtomicCounter getAtomicCounter(String name) {
        if (this.atomicCounters.containsKey(name)) {
            return (AtomicCounter)this.atomicCounters.get(name);
        }
        StandaloneAtomicCounter counter = new StandaloneAtomicCounter(new AtomicLong(0L));
        AtomicCounter existingCounter = this.atomicCounters.putIfAbsent(name, counter);
        if (existingCounter == null) {
            existingCounter = counter;
        }
        return existingCounter;
    }

    private class IListImpl<E>
    extends ICollectionImpl<E>
    implements IList<E> {
        private List<E> list;

        public IListImpl(String name) {
            super(name);
            this.list = Collections.synchronizedList(new LinkedList());
        }

        public boolean add(E element) {
            return this.list.add(element);
        }

        public void add(int index, E element) {
            this.list.add(index, element);
        }

        public boolean addAll(Collection<? extends E> c) {
            return this.list.addAll(c);
        }

        public boolean addAll(int index, Collection<? extends E> c) {
            return this.list.addAll(index, c);
        }

        public void clear() {
            this.list.clear();
        }

        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        public boolean containsAll(Collection<?> c) {
            return this.list.containsAll(c);
        }

        public E get(int index) {
            return this.list.get(index);
        }

        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public Iterator<E> iterator() {
            return this.list.iterator();
        }

        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        public ListIterator<E> listIterator() {
            return this.list.listIterator();
        }

        public ListIterator<E> listIterator(int index) {
            return this.list.listIterator(index);
        }

        public E remove(int index) {
            return this.list.remove(index);
        }

        public boolean remove(Object o) {
            return this.list.remove(o);
        }

        public boolean removeAll(Collection<?> c) {
            return this.list.removeAll(c);
        }

        public boolean retainAll(Collection<?> c) {
            return this.list.retainAll(c);
        }

        public E set(int index, E element) {
            return this.list.set(index, element);
        }

        public int size() {
            return this.list.size();
        }

        public List<E> subList(int fromIndex, int toIndex) {
            return this.list.subList(fromIndex, toIndex);
        }

        public Object[] toArray() {
            return this.list.toArray();
        }

        public <T> T[] toArray(T[] a) {
            return this.list.toArray(a);
        }

        public String getPartitionKey() {
            return null;
        }

        public String getServiceName() {
            return null;
        }

        public void destroy() {
            MemoryCollectionsFactory.this.lists.remove(this.getName(), this);
            this.list = Collections.synchronizedList(new LinkedList());
        }
    }

    private abstract class ICollectionImpl<E>
    implements ICollection<E> {
        private final String name;

        public ICollectionImpl(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String addItemListener(ItemListener<E> listener, boolean includeValue) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "addItemListener"));
        }

        public boolean removeItemListener(String registrationId) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "removeItemListener"));
        }
    }

    private class ILockImpl
    implements ILock {
        private final String name;
        private final Lock lock;

        public ILockImpl(String name) {
            this.name = name;
            this.lock = new ReentrantLock();
        }

        public void lockInterruptibly() throws InterruptedException {
            this.lock.lockInterruptibly();
        }

        public String getPartitionKey() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String getServiceName() {
            return null;
        }

        public void destroy() {
            MemoryCollectionsFactory.this.locks.remove(this.name);
        }

        @Deprecated
        public Object getKey() {
            return this.getName();
        }

        public void lock() {
            this.lock.lock();
        }

        public boolean tryLock() {
            return this.lock.tryLock();
        }

        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.lock.tryLock(time, unit);
        }

        public boolean tryLock(long time, TimeUnit unit, long leaseTime, TimeUnit leaseUnit) throws InterruptedException {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "tryLock with lease time"));
        }

        public void unlock() {
            this.lock.unlock();
        }

        public void lock(long leaseTime, TimeUnit timeUnit) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "lock with lease time"));
        }

        public void forceUnlock() {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "forceUnlock"));
        }

        public Condition newCondition() {
            return this.lock.newCondition();
        }

        public ICondition newCondition(String name) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "newCondition"));
        }

        public boolean isLocked() {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "isLocked"));
        }

        public boolean isLockedByCurrentThread() {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "isLockedByCurrentThread"));
        }

        public int getLockCount() {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "getLockCount"));
        }

        public long getRemainingLeaseTime() {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "getRemainingLeaseTime"));
        }
    }

    private class IMapImpl<K, V>
    implements IMap<K, V> {
        private final ConcurrentHashMap<K, V> map;
        private final ConcurrentHashMap<K, Long> keyExpirations;
        private final String name;

        public IMapImpl(String name) {
            this.name = name;
            this.map = new ConcurrentHashMap();
            this.keyExpirations = new ConcurrentHashMap();
        }

        public int size() {
            this.removeExpiredEntries();
            return this.map.size();
        }

        public boolean isEmpty() {
            this.removeExpiredEntries();
            return this.map.isEmpty();
        }

        public String getPartitionKey() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String getServiceName() {
            return null;
        }

        public void destroy() {
            MemoryCollectionsFactory.this.maps.remove(this.getName());
            this.keyExpirations.clear();
            this.map.clear();
        }

        public void putAll(Map<? extends K, ? extends V> m) {
            this.removeExpiredEntries();
            this.map.putAll(m);
        }

        public boolean containsKey(Object key) {
            return !this.evictEntryIfExpired(key) && this.map.containsKey(key);
        }

        public boolean containsValue(Object value) {
            this.removeExpiredEntries();
            return this.map.containsValue(value);
        }

        public V get(Object key) {
            if (this.evictEntryIfExpired(key)) {
                return null;
            }
            return this.map.get(key);
        }

        public V put(K key, V value) {
            this.removeExpiredEntries();
            return this.map.put(key, value);
        }

        public V remove(Object key) {
            this.removeExpiredEntries();
            this.keyExpirations.remove(key);
            return this.map.remove(key);
        }

        private void removeExpiredEntries() {
            long currentMillis = System.currentTimeMillis();
            this.keyExpirations.entrySet().removeIf(e -> {
                Long expiration = (Long)e.getValue();
                if (currentMillis >= expiration) {
                    this.map.remove(e.getKey());
                    return true;
                }
                return false;
            });
        }

        private boolean evictEntryIfExpired(Object key) {
            long currentMillis = System.currentTimeMillis();
            Long expiration = this.keyExpirations.get(key);
            if (expiration != null && currentMillis >= expiration) {
                this.map.remove(key);
                this.keyExpirations.remove(key);
                return true;
            }
            return false;
        }

        public boolean remove(Object key, Object value) {
            this.keyExpirations.remove(key, value);
            return this.map.remove(key, value);
        }

        public void delete(Object key) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "delete"));
        }

        public void flush() {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "flush"));
        }

        public Map<K, V> getAll(Set<K> keys) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "getAll"));
        }

        public void loadAll(boolean replaceExistingValues) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "loadAll"));
        }

        public void loadAll(Set<K> keys, boolean replaceExistingValues) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "loadAll"));
        }

        public void clear() {
            this.map.clear();
            this.keyExpirations.clear();
        }

        public ICompletableFuture<V> getAsync(K key) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "getAsync"));
        }

        public ICompletableFuture<V> putAsync(K key, V value) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "putAsync"));
        }

        public ICompletableFuture<V> putAsync(K key, V value, long ttl, TimeUnit timeunit) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "putAsync"));
        }

        public ICompletableFuture<Void> setAsync(K key, V value) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "setAsync"));
        }

        public ICompletableFuture<Void> setAsync(K key, V value, long ttl, TimeUnit timeunit) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "setAsync"));
        }

        public ICompletableFuture<V> removeAsync(K key) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "removeAsync"));
        }

        public boolean tryRemove(K key, long timeout, TimeUnit timeunit) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "tryRemove"));
        }

        public boolean tryPut(K key, V value, long timeout, TimeUnit timeunit) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "tryPut"));
        }

        public V put(K key, V value, long ttl, TimeUnit timeunit) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "put"));
        }

        public void putTransient(K key, V value, long ttl, TimeUnit timeunit) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "putTransient"));
        }

        public V putIfAbsent(K key, V value) {
            this.removeExpiredEntries();
            return this.map.putIfAbsent(key, value);
        }

        public V putIfAbsent(K key, V value, long ttl, TimeUnit timeunit) {
            this.removeExpiredEntries();
            V oldValue = this.map.putIfAbsent(key, value);
            if (oldValue == null) {
                this.keyExpirations.put(key, System.currentTimeMillis() + timeunit.toMillis(ttl));
            }
            return oldValue;
        }

        public boolean replace(K key, V oldValue, V newValue) {
            this.removeExpiredEntries();
            return this.map.replace(key, oldValue, newValue);
        }

        public V replace(K key, V value) {
            this.removeExpiredEntries();
            return this.map.replace(key, value);
        }

        public void set(K key, V value) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "set"));
        }

        public void set(K key, V value, long ttl, TimeUnit timeunit) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "set"));
        }

        public void lock(K key) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "lock"));
        }

        public void lock(K key, long leaseTime, TimeUnit timeUnit) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "lock"));
        }

        public boolean isLocked(K key) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "isLocked"));
        }

        public boolean tryLock(K key) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "tryLock"));
        }

        public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "tryLock"));
        }

        public boolean tryLock(K key, long time, TimeUnit timeunit, long leaseTime, TimeUnit leaseTimeunit) throws InterruptedException {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "tryLock"));
        }

        public void unlock(K key) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "unlock"));
        }

        public void forceUnlock(K key) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "forceUnlock"));
        }

        public String addLocalEntryListener(MapListener listener) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "addLocalEntryListener"));
        }

        public String addLocalEntryListener(EntryListener listener) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "addLocalEntryListener"));
        }

        public String addLocalEntryListener(MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "addLocalEntryListener"));
        }

        public String addLocalEntryListener(EntryListener listener, Predicate<K, V> predicate, boolean includeValue) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "addLocalEntryListener"));
        }

        public String addLocalEntryListener(MapListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "addLocalEntryListener"));
        }

        public String addLocalEntryListener(EntryListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "addLocalEntryListener"));
        }

        public String addInterceptor(MapInterceptor interceptor) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "addInterceptor"));
        }

        public void removeInterceptor(String id) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "removeInterceptor"));
        }

        public String addEntryListener(MapListener listener, boolean includeValue) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "addEntryListener"));
        }

        public String addEntryListener(EntryListener listener, boolean includeValue) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "addEntryListener"));
        }

        public boolean removeEntryListener(String id) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "removeEntryListener"));
        }

        public String addPartitionLostListener(MapPartitionLostListener listener) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "addPartitionLostListener"));
        }

        public boolean removePartitionLostListener(String id) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "removePartitionLostListener"));
        }

        public String addEntryListener(MapListener listener, K key, boolean includeValue) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "addEntryListener"));
        }

        public String addEntryListener(EntryListener listener, K key, boolean includeValue) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "addEntryListener"));
        }

        public String addEntryListener(MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "addEntryListener"));
        }

        public String addEntryListener(EntryListener listener, Predicate<K, V> predicate, boolean includeValue) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "addEntryListener"));
        }

        public String addEntryListener(MapListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "addEntryListener"));
        }

        public String addEntryListener(EntryListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "addEntryListener"));
        }

        public EntryView<K, V> getEntryView(K key) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "getEntryView"));
        }

        public boolean evict(K key) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "evict"));
        }

        public void evictAll() {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "evictAll"));
        }

        public Set<K> keySet() {
            this.removeExpiredEntries();
            return this.map.keySet();
        }

        public Collection<V> values() {
            this.removeExpiredEntries();
            return this.map.values();
        }

        public Set<Map.Entry<K, V>> entrySet() {
            this.removeExpiredEntries();
            return this.map.entrySet();
        }

        public Set<K> keySet(Predicate predicate) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "keySet"));
        }

        public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "entrySet"));
        }

        public Collection<V> values(Predicate predicate) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "values"));
        }

        public Set<K> localKeySet() {
            return this.keySet();
        }

        public Set<K> localKeySet(Predicate predicate) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "localKeySet"));
        }

        public void addIndex(String attribute, boolean ordered) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "addIndex"));
        }

        public LocalMapStats getLocalMapStats() {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "getLocalMapStats"));
        }

        public Object executeOnKey(K key, EntryProcessor entryProcessor) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "executeOnKey"));
        }

        public Map<K, Object> executeOnKeys(Set<K> keys, EntryProcessor entryProcessor) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "executeOnKeys"));
        }

        public void submitToKey(K key, EntryProcessor entryProcessor, ExecutionCallback callback) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "submitToKey"));
        }

        public ICompletableFuture submitToKey(K key, EntryProcessor entryProcessor) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "submitToKey"));
        }

        public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "executeOnEntries"));
        }

        public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor, Predicate predicate) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "executeOnEntries"));
        }

        public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "aggregate"));
        }

        public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
            throw new UnsupportedOperationException(String.format(MemoryCollectionsFactory.OPERATION_NOT_SUPPORTED_MESSAGE, "aggregate"));
        }
    }

    private class StandaloneAtomicCounter
    implements AtomicCounter {
        private AtomicLong atomicLong;

        private StandaloneAtomicCounter(AtomicLong number) {
            this.atomicLong = number;
        }

        public long get() {
            return this.atomicLong.get();
        }

        public long incrementAndGet() {
            return this.atomicLong.incrementAndGet();
        }

        public long decrementAndGet() {
            return this.atomicLong.decrementAndGet();
        }

        public boolean compareAndSet(long expect, long update) {
            return this.atomicLong.compareAndSet(expect, update);
        }
    }
}

