/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.kaazing.gateway.service.Service;
import org.kaazing.gateway.service.ServiceFactorySpi;

public final class ServiceFactory {
    private final Map<String, ServiceFactorySpi> serviceFactoriesByType;

    private ServiceFactory(Map<String, ServiceFactorySpi> serviceFactoriesByType) {
        this.serviceFactoriesByType = Collections.unmodifiableMap(serviceFactoriesByType);
    }

    public static ServiceFactory newServiceFactory() {
        return ServiceFactory.newServiceFactory(ServiceLoader.load(ServiceFactorySpi.class));
    }

    public static ServiceFactory newServiceFactory(ClassLoader loader) {
        return ServiceFactory.newServiceFactory(ServiceLoader.load(ServiceFactorySpi.class, loader));
    }

    public Service newService(String serviceType) {
        ServiceFactorySpi serviceFactory = this.serviceFactoriesByType.get(serviceType);
        if (serviceFactory == null) {
            throw new IllegalArgumentException("Unrecognized service type: " + serviceType);
        }
        return serviceFactory.newService(serviceType);
    }

    private static ServiceFactory newServiceFactory(ServiceLoader<ServiceFactorySpi> serviceFactories) {
        ConcurrentHashMap<String, ServiceFactorySpi> serviceFactoriesByType = new ConcurrentHashMap<String, ServiceFactorySpi>();
        for (ServiceFactorySpi serviceFactory : serviceFactories) {
            Collection<String> serviceTypes = serviceFactory.getServiceTypes();
            for (String serviceType : serviceTypes) {
                ServiceFactorySpi oldServiceFactory = serviceFactoriesByType.putIfAbsent(serviceType, serviceFactory);
                if (oldServiceFactory == null) continue;
                throw new RuntimeException(String.format("Duplicate type service factory: %s", serviceType));
            }
        }
        return new ServiceFactory(serviceFactoriesByType);
    }
}

