/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.messaging.collections;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.ICollection;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Instance;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.MapEntry;
import com.hazelcast.monitor.LocalLockStats;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.query.Expression;
import com.hazelcast.query.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.kaazing.gateway.service.cluster.EntryListenerSupport;
import org.kaazing.gateway.service.messaging.collections.CollectionsFactory;
import org.kaazing.gateway.util.AtomicCounter;

public class MemoryCollectionsFactory
implements CollectionsFactory {
    private final ConcurrentMap<String, IMapImpl<?, ?>> maps = new ConcurrentHashMap();
    private final ConcurrentMap<String, IListImpl<?>> lists = new ConcurrentHashMap();
    private final Map<Object, ILockImpl> locks = Collections.synchronizedMap(new WeakHashMap());
    private final ConcurrentMap<String, AtomicCounter> atomicCounters = new ConcurrentHashMap<String, AtomicCounter>();

    @Override
    public <E> IList<E> getList(String name) {
        IListImpl newList;
        IListImpl list = (IListImpl)this.lists.get(name);
        if (list == null && (list = this.lists.putIfAbsent(name, newList = new IListImpl(name))) == null) {
            list = newList;
        }
        return list;
    }

    @Override
    public <E> IQueue<E> getQueue(String name) {
        return new IQueueImpl(name, 100);
    }

    @Override
    public <E> ITopic<E> getTopic(String name) {
        throw new UnsupportedOperationException("getTopic");
    }

    @Override
    public <K, V> IMap<K, V> getMap(String name) {
        IMapImpl newMap;
        IMapImpl map = (IMapImpl)this.maps.get(name);
        if (map == null && (map = this.maps.putIfAbsent(name, newMap = new IMapImpl(name))) == null) {
            map = newMap;
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILock getLock(Object owner) {
        Map<Object, ILockImpl> map = this.locks;
        synchronized (map) {
            ILock lock = this.locks.get(owner);
            if (lock == null) {
                ILockImpl newLock = new ILockImpl(owner);
                this.locks.put(owner, newLock);
                lock = newLock;
            }
            assert (lock != null);
            return lock;
        }
    }

    @Override
    public <K, V> void addEntryListener(EntryListener<K, V> listener, String name) {
        IMapImpl map = (IMapImpl)this.getMap(name);
        map.addEntryListener(listener, true);
    }

    @Override
    public AtomicCounter getAtomicCounter(String name) {
        if (this.atomicCounters.containsKey(name)) {
            return (AtomicCounter)this.atomicCounters.get(name);
        }
        StandaloneAtomicCounter counter = new StandaloneAtomicCounter(new AtomicLong(0L));
        AtomicCounter existingCounter = this.atomicCounters.putIfAbsent(name, counter);
        if (existingCounter == null) {
            existingCounter = counter;
        }
        return existingCounter;
    }

    private class ItemListenerSupport<E> {
        private ConcurrentHashMap<ItemListener<E>, Boolean> listenersMap = new ConcurrentHashMap();

        private ItemListenerSupport() {
        }

        public void addItemListener(ItemListener<E> listener, boolean includeValue) {
            this.listenersMap.put(listener, includeValue);
        }

        public void removeItemListener(ItemListener<E> listener) {
            this.listenersMap.remove(listener);
        }

        public void fireItemAdded(Iterator<? extends E> iterator) {
            while (iterator.hasNext()) {
                this.fireItemAdded(iterator.next());
            }
        }

        public void fireItemAdded(E item) {
            Iterator i$ = this.listenersMap.keySet().iterator();
            while (i$.hasNext()) {
                ItemListener listener;
                listener.itemAdded(this.listenersMap.get(listener = (ItemListener)i$.next()) != false ? item : null);
            }
        }

        public void fireItemRemoved(Iterator<? super E> iterator) {
            while (iterator.hasNext()) {
                this.fireItemRemoved(iterator.next());
            }
        }

        public void fireItemRemoved(Object item) {
            Iterator i$ = this.listenersMap.keySet().iterator();
            while (i$.hasNext()) {
                ItemListener listener;
                listener.itemRemoved(this.listenersMap.get(listener = (ItemListener)i$.next()) != false ? item : null);
            }
        }
    }

    private class IQueueImpl<E>
    implements IQueue<E> {
        private ArrayBlockingQueue<E> queue;
        private static final long serialVersionUID = 1L;
        private final String name;
        private final int capacity;
        private final ItemListenerSupport<E> itemListenerSupport;

        public IQueueImpl(String name, int capacity) {
            this.name = name;
            this.capacity = capacity;
            this.queue = new ArrayBlockingQueue(capacity);
            this.itemListenerSupport = new ItemListenerSupport();
        }

        public void addItemListener(ItemListener<E> listener, boolean includeValue) {
            this.itemListenerSupport.addItemListener(listener, includeValue);
        }

        public String getName() {
            return this.name;
        }

        public void removeItemListener(ItemListener<E> listener) {
            this.itemListenerSupport.removeItemListener(listener);
        }

        public void destroy() {
            this.queue.clear();
        }

        public Object getId() {
            return this.name;
        }

        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.QUEUE;
        }

        public boolean add(E e) {
            boolean added = this.queue.add(e);
            this.itemListenerSupport.fireItemAdded(e);
            return added;
        }

        public void clear() {
            ArrayBlockingQueue<E> oldQueue = this.queue;
            this.queue = new ArrayBlockingQueue(this.capacity);
            this.itemListenerSupport.fireItemRemoved(oldQueue.iterator());
            oldQueue.clear();
        }

        public int drainTo(Collection<? super E> c, int maxElements) {
            int drained = this.queue.drainTo(c, maxElements);
            this.itemListenerSupport.fireItemRemoved(c.iterator());
            return drained;
        }

        public int drainTo(Collection<? super E> c) {
            int drained = this.queue.drainTo(c);
            this.itemListenerSupport.fireItemRemoved(c.iterator());
            return drained;
        }

        public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
            boolean offered = this.queue.offer(e, timeout, unit);
            this.itemListenerSupport.fireItemAdded(e);
            return offered;
        }

        public boolean offer(E e) {
            boolean offered = this.queue.offer(e);
            this.itemListenerSupport.fireItemAdded(e);
            return offered;
        }

        public E poll() {
            E item = this.queue.poll();
            this.itemListenerSupport.fireItemRemoved(item);
            return item;
        }

        public E poll(long timeout, TimeUnit unit) throws InterruptedException {
            E item = this.queue.poll(timeout, unit);
            this.itemListenerSupport.fireItemRemoved(item);
            return item;
        }

        public void put(E e) throws InterruptedException {
            this.queue.put(e);
            this.itemListenerSupport.fireItemAdded(e);
        }

        public boolean remove(Object o) {
            boolean removed = this.queue.remove(o);
            this.itemListenerSupport.fireItemRemoved(o);
            return removed;
        }

        public E take() throws InterruptedException {
            E item = this.queue.take();
            this.itemListenerSupport.fireItemRemoved(item);
            return item;
        }

        public boolean addAll(Collection<? extends E> c) {
            boolean allAdded = this.queue.addAll(c);
            this.itemListenerSupport.fireItemAdded(c.iterator());
            return allAdded;
        }

        public E remove() {
            Object item = this.queue.remove();
            this.itemListenerSupport.fireItemRemoved(item);
            return item;
        }

        public boolean removeAll(Collection<?> c) {
            boolean allRemoved = this.queue.removeAll(c);
            this.itemListenerSupport.fireItemRemoved((Object)c.iterator());
            return allRemoved;
        }

        public boolean contains(Object o) {
            return this.queue.contains(o);
        }

        public int remainingCapacity() {
            return this.queue.remainingCapacity();
        }

        public E element() {
            return this.queue.element();
        }

        public E peek() {
            return this.queue.peek();
        }

        public boolean containsAll(Collection<?> c) {
            return this.queue.containsAll(c);
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public Iterator<E> iterator() {
            return this.queue.iterator();
        }

        public boolean retainAll(Collection<?> c) {
            return this.queue.retainAll(c);
        }

        public int size() {
            return this.queue.size();
        }

        public Object[] toArray() {
            return this.queue.toArray();
        }

        public <T> T[] toArray(T[] a) {
            return this.queue.toArray(a);
        }

        public LocalQueueStats getLocalQueueStats() {
            throw new UnsupportedOperationException("getLocalQueueStats");
        }
    }

    private class IListImpl<E>
    extends ICollectionImpl<E>
    implements IList<E> {
        private List<E> list;

        public IListImpl(String name) {
            super(name);
            this.list = new LinkedList();
        }

        @Override
        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.LIST;
        }

        public boolean add(E e) {
            return this.list.add(e);
        }

        public void add(int index, E element) {
            this.list.add(index, element);
            this.listenerSupport.fireItemAdded(element);
        }

        public boolean addAll(Collection<? extends E> c) {
            return this.list.addAll(c);
        }

        public boolean addAll(int index, Collection<? extends E> c) {
            return this.list.addAll(index, c);
        }

        public void clear() {
            Iterator<E> iterator = this.list.iterator();
            this.listenerSupport.fireItemRemoved(iterator);
            this.list = new LinkedList();
        }

        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        public boolean containsAll(Collection<?> c) {
            return this.list.containsAll(c);
        }

        public E get(int index) {
            return this.list.get(index);
        }

        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public Iterator<E> iterator() {
            return this.list.iterator();
        }

        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        public ListIterator<E> listIterator() {
            return this.list.listIterator();
        }

        public ListIterator<E> listIterator(int index) {
            return this.list.listIterator(index);
        }

        public E remove(int index) {
            E element = this.list.remove(index);
            this.listenerSupport.fireItemRemoved(element);
            return element;
        }

        public boolean remove(Object o) {
            boolean wasRemoved = this.list.remove(o);
            if (wasRemoved) {
                this.listenerSupport.fireItemRemoved(o);
            }
            return wasRemoved;
        }

        public boolean removeAll(Collection<?> c) {
            boolean wasAnyRemoved = false;
            for (Object o : c) {
                wasAnyRemoved |= this.remove(o);
            }
            return wasAnyRemoved;
        }

        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("retainAll does not support notifications");
        }

        public E set(int index, E element) {
            E oldValue = this.list.set(index, element);
            if (oldValue != element) {
                this.listenerSupport.fireItemRemoved(oldValue);
                this.listenerSupport.fireItemAdded(element);
            }
            return oldValue;
        }

        public int size() {
            return this.list.size();
        }

        public List<E> subList(int fromIndex, int toIndex) {
            return this.list.subList(fromIndex, toIndex);
        }

        public Object[] toArray() {
            return this.list.toArray();
        }

        public <T> T[] toArray(T[] a) {
            return this.list.toArray(a);
        }
    }

    private abstract class ICollectionImpl<E>
    extends InstanceImpl
    implements ICollection<E> {
        private final String name;
        protected final ItemListenerSupport<E> listenerSupport;

        public ICollectionImpl(String name) {
            this.name = name;
            this.listenerSupport = new ItemListenerSupport();
        }

        public String getName() {
            return this.name;
        }

        public void addItemListener(ItemListener<E> listener, boolean includeValue) {
            this.listenerSupport.addItemListener(listener, includeValue);
        }

        public void removeItemListener(ItemListener<E> listener) {
            this.listenerSupport.removeItemListener(listener);
        }
    }

    private class ILockImpl
    extends InstanceImpl
    implements ILock {
        private final Object owner;
        private final Lock lock;

        public ILockImpl(Object owner) {
            this.owner = owner;
            this.lock = new ReentrantLock();
        }

        public void lock() {
            this.lock.lock();
        }

        public void lockInterruptibly() throws InterruptedException {
            this.lock.lockInterruptibly();
        }

        public Condition newCondition() {
            return this.lock.newCondition();
        }

        public boolean tryLock() {
            return this.lock.tryLock();
        }

        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.lock.tryLock(time, unit);
        }

        public void unlock() {
            this.lock.unlock();
        }

        @Override
        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.LOCK;
        }

        public Object getLockObject() {
            return this.owner;
        }

        @Override
        public void destroy() {
            MemoryCollectionsFactory.this.locks.remove(this.owner);
        }

        public LocalLockStats getLocalLockStats() {
            return null;
        }
    }

    private abstract class InstanceImpl
    implements Instance {
        private InstanceImpl() {
        }

        public abstract Instance.InstanceType getInstanceType();

        public Object getId() {
            return this;
        }

        public void destroy() {
        }
    }

    private class IMapImpl<K, V>
    implements IMap<K, V> {
        private final ConcurrentHashMap<K, V> map;
        private final EntryListenerSupport<K, V> listenerSupport;
        private final ConcurrentMap<Object, Lock> locks;
        private final String name;

        public IMapImpl(String name) {
            this.name = name;
            this.map = new ConcurrentHashMap();
            this.listenerSupport = new EntryListenerSupport();
            this.locks = new ConcurrentHashMap<Object, Lock>();
        }

        public void addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
            this.listenerSupport.addEntryListener(listener, includeValue);
        }

        public void addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
            this.listenerSupport.addEntryListener(listener, key, includeValue);
        }

        public MapEntry<K, V> getMapEntry(K key) {
            V value = this.map.get(key);
            return new MapEntryImpl<K, V>(key, value);
        }

        public String getName() {
            return this.name;
        }

        public void lock(K key) {
            this.supplyLock(key).lock();
        }

        public void removeEntryListener(EntryListener<K, V> listener) {
            this.listenerSupport.removeEntryListener(listener);
        }

        public void removeEntryListener(EntryListener<K, V> listener, K key) {
            this.listenerSupport.removeEntryListener(listener, key);
        }

        public boolean tryLock(K key) {
            return this.supplyLock(key).tryLock();
        }

        public boolean tryLock(K key, long time, TimeUnit timeunit) {
            try {
                return this.supplyLock(key).tryLock(time, timeunit);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }

        public void unlock(K key) {
            this.supplyLock(key).unlock();
        }

        public V putIfAbsent(K key, V value) {
            V oldValue = this.map.putIfAbsent(key, value);
            if (oldValue == null) {
                EntryEvent event = new EntryEvent((Object)this.name, null, EntryEvent.TYPE_ADDED, key, value);
                this.listenerSupport.entryAdded(event);
            } else {
                EntryEvent event = new EntryEvent((Object)this.name, null, EntryEvent.TYPE_UPDATED, key, value);
                this.listenerSupport.entryUpdated(event);
            }
            return oldValue;
        }

        public boolean remove(Object key, Object value) {
            boolean wasRemoved = this.map.remove(key, value);
            if (wasRemoved) {
                EntryEvent event = new EntryEvent((Object)this.name, null, EntryEvent.TYPE_REMOVED, key, value);
                this.listenerSupport.entryRemoved(event);
            }
            return wasRemoved;
        }

        public V replace(K key, V value) {
            V oldValue = this.map.replace(key, value);
            if (oldValue != null) {
                EntryEvent event = new EntryEvent((Object)this.name, null, EntryEvent.TYPE_UPDATED, key, value);
                this.listenerSupport.entryUpdated(event);
            } else {
                EntryEvent event = new EntryEvent((Object)this.name, null, EntryEvent.TYPE_ADDED, key, value);
                this.listenerSupport.entryAdded(event);
            }
            return oldValue;
        }

        public boolean replace(K key, V oldValue, V newValue) {
            boolean wasReplaced = this.map.replace(key, oldValue, newValue);
            if (wasReplaced) {
                EntryEvent event = new EntryEvent((Object)this.name, null, EntryEvent.TYPE_UPDATED, key, newValue);
                this.listenerSupport.entryUpdated(event);
            }
            return wasReplaced;
        }

        public void clear() {
            Set<Map.Entry<K, V>> entries = this.map.entrySet();
            for (Map.Entry<K, V> entry : entries) {
                this.remove(entry.getKey(), entry.getValue());
            }
        }

        public boolean containsKey(Object key) {
            return this.map.contains(key);
        }

        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        public Set<Map.Entry<K, V>> entrySet() {
            return this.map.entrySet();
        }

        public V get(Object key) {
            return this.map.get(key);
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Set<K> keySet() {
            return this.map.keySet();
        }

        public V put(K key, V value) {
            V oldValue = this.map.put(key, value);
            if (oldValue != null) {
                EntryEvent event = new EntryEvent((Object)this.name, null, EntryEvent.TYPE_UPDATED, key, value);
                this.listenerSupport.entryUpdated(event);
            } else {
                EntryEvent event = new EntryEvent((Object)this.name, null, EntryEvent.TYPE_ADDED, key, value);
                this.listenerSupport.entryAdded(event);
            }
            return oldValue;
        }

        public void putAll(Map<? extends K, ? extends V> m) {
            Set<K> keys = m.keySet();
            for (K key : keys) {
                this.put(key, m.get(key));
            }
        }

        public int size() {
            return this.map.size();
        }

        public Collection<V> values() {
            return this.map.values();
        }

        public void destroy() {
            this.map.clear();
        }

        public Object getId() {
            return this;
        }

        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.MAP;
        }

        private Lock supplyLock(Object key) {
            ReentrantLock newLock;
            Lock lock = (Lock)this.locks.get(key);
            if (lock == null && (lock = this.locks.putIfAbsent(key, newLock = new ReentrantLock())) == null) {
                lock = newLock;
            }
            assert (lock != null);
            return lock;
        }

        public void addIndex(String attribute, boolean ordered) {
        }

        public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
            LinkedHashSet<Map.Entry<K, V>> entrySet = new LinkedHashSet<Map.Entry<K, V>>();
            for (Map.Entry<K, V> entry : this.map.entrySet()) {
                MapEntry<K, V> me = this.getMapEntry(entry.getKey());
                if (!predicate.apply(me)) continue;
                entrySet.add(entry);
            }
            return entrySet;
        }

        public boolean evict(Object key) {
            boolean removed;
            V value = this.map.remove(key);
            boolean bl = removed = value != null;
            if (removed) {
                EntryEvent event = new EntryEvent((Object)this.name, null, EntryEvent.TYPE_EVICTED, key, value);
                this.listenerSupport.entryEvicted(event);
            }
            return removed;
        }

        public LocalMapStats getLocalMapStats() {
            throw new UnsupportedOperationException("getLocalMapStats");
        }

        public Set<K> keySet(Predicate predicate) {
            LinkedHashSet keySet = new LinkedHashSet();
            for (Object key : this.map.keySet()) {
                MapEntry me = this.getMapEntry(key);
                if (!predicate.apply(me)) continue;
                keySet.add(key);
            }
            return keySet;
        }

        public Set<K> localKeySet() {
            return this.map.keySet();
        }

        public Set<K> localKeySet(Predicate predicate) {
            return this.keySet(predicate);
        }

        public boolean lockMap(long time, TimeUnit timeunit) {
            throw new UnsupportedOperationException("lockMap");
        }

        public V put(K key, V value, long ttl, TimeUnit timeunit) {
            throw new UnsupportedOperationException("put");
        }

        public V putIfAbsent(K key, V value, long ttl, TimeUnit timeunit) {
            throw new UnsupportedOperationException("putIfAbsent");
        }

        public boolean tryPut(K key, V value, long timeout, TimeUnit timeunit) {
            throw new UnsupportedOperationException("tryPut");
        }

        public void unlockMap() {
            throw new UnsupportedOperationException("unlockMap");
        }

        public Collection<V> values(Predicate predicate) {
            LinkedHashSet<V> values = new LinkedHashSet<V>();
            for (Map.Entry<K, V> entry : this.map.entrySet()) {
                MapEntry<K, V> me = this.getMapEntry(entry.getKey());
                if (!predicate.apply(me)) continue;
                values.add(entry.getValue());
            }
            return values;
        }

        public V remove(Object key) {
            boolean removed;
            V value = this.map.remove(key);
            boolean bl = removed = value != null;
            if (removed) {
                EntryEvent event = new EntryEvent((Object)this.name, null, EntryEvent.TYPE_REMOVED, key, value);
                this.listenerSupport.entryRemoved(event);
            }
            return value;
        }

        public Future<V> getAsync(K key) {
            throw new UnsupportedOperationException("getAsync");
        }

        public Future<V> putAsync(K key, V value) {
            throw new UnsupportedOperationException("putAsync");
        }

        public void addIndex(Expression<?> arg0, boolean arg1) {
            throw new UnsupportedOperationException("addIndex");
        }

        public void addLocalEntryListener(EntryListener<K, V> arg0) {
            throw new UnsupportedOperationException("addLocalEntryListener");
        }

        public void flush() {
            throw new UnsupportedOperationException("flush");
        }

        public Map<K, V> getAll(Set<K> arg0) {
            throw new UnsupportedOperationException("getAll");
        }

        public void putAndUnlock(K arg0, V arg1) {
            throw new UnsupportedOperationException("putAndLock");
        }

        public void putTransient(K arg0, V arg1, long arg2, TimeUnit arg3) {
            throw new UnsupportedOperationException("putTransient");
        }

        public Future<V> removeAsync(K arg0) {
            throw new UnsupportedOperationException("removeAsync");
        }

        public V tryLockAndGet(K arg0, long arg1, TimeUnit arg2) throws TimeoutException {
            throw new UnsupportedOperationException("tryLockAndGet");
        }

        public Object tryRemove(K arg0, long arg1, TimeUnit arg2) throws TimeoutException {
            throw new UnsupportedOperationException("tryRemove");
        }
    }

    private class MapEntryImpl<K, V>
    implements MapEntry<K, V> {
        private final K key;
        private final V value;

        public MapEntryImpl(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public long getCost() {
            return 0L;
        }

        public long getCreationTime() {
            return 0L;
        }

        public int getHits() {
            return 1;
        }

        public long getExpirationTime() {
            return Long.MAX_VALUE;
        }

        public long getLastAccessTime() {
            return Long.MAX_VALUE;
        }

        public long getLastStoredTime() {
            return 0L;
        }

        public long getLastUpdateTime() {
            return 0L;
        }

        public long getVersion() {
            return 1L;
        }

        public boolean isValid() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof MapEntry)) {
                return false;
            }
            MapEntry that = (MapEntry)o;
            return that.getKey().equals(this.getKey()) && that.getValue().equals(this.getValue());
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V value) {
            throw new UnsupportedOperationException("setValue");
        }

        public int hashCode() {
            int hashCode = this.key.hashCode();
            return hashCode ^= this.value.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ ");
            sb.append("key=").append(this.key);
            sb.append(", value=").append(this.value);
            sb.append(" }");
            return sb.toString();
        }
    }

    private class StandaloneAtomicCounter
    implements AtomicCounter {
        private AtomicLong atomicLong;

        private StandaloneAtomicCounter(AtomicLong number) {
            this.atomicLong = number;
        }

        public long get() {
            return this.atomicLong.get();
        }

        public long incrementAndGet() {
            return this.atomicLong.incrementAndGet();
        }

        public long decrementAndGet() {
            return this.atomicLong.decrementAndGet();
        }

        public boolean compareAndSet(long expect, long update) {
            return this.atomicLong.compareAndSet(expect, update);
        }
    }
}

