/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.turn.rest.internal;

import java.util.Arrays;
import javax.security.auth.Subject;
import org.kaazing.gateway.service.turn.rest.TurnRestCredentials;
import org.kaazing.gateway.service.turn.rest.TurnRestCredentialsGenerator;
import org.kaazing.gateway.service.turn.rest.internal.TurnRestJSONResponse;
import org.kaazing.gateway.transport.IoHandlerAdapter;
import org.kaazing.gateway.transport.http.HttpAcceptSession;
import org.kaazing.gateway.transport.http.HttpMethod;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.gateway.util.turn.TurnException;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TurnRestServiceHandler
extends IoHandlerAdapter<HttpAcceptSession> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TurnRestServiceHandler.class);
    private TurnRestCredentialsGenerator credentialGenerator;
    private String urls;
    private String ttl;

    TurnRestServiceHandler(String ttl, TurnRestCredentialsGenerator credentialGenerator, String urls) {
        this.ttl = ttl;
        this.credentialGenerator = credentialGenerator;
        this.urls = urls;
    }

    protected void doSessionOpened(HttpAcceptSession session) throws Exception {
        HttpMethod method = session.getMethod();
        String service = session.getParameter("service");
        if (method != HttpMethod.GET) {
            session.setStatus(HttpStatus.CLIENT_METHOD_NOT_ALLOWED);
            session.close(false);
            throw new IllegalArgumentException("HTTP method not allowed: " + method);
        }
        if (!"turn".equals(service)) {
            session.setStatus(HttpStatus.CLIENT_BAD_REQUEST);
            session.close(false);
            throw new IllegalArgumentException("Unsupported/invalid service: " + service);
        }
        session.setVersion(HttpVersion.HTTP_1_1);
        session.setWriteHeader("Content-Type", "application/json");
        String username = null;
        char[] password = null;
        if (this.credentialGenerator != null) {
            Subject subject = session.getSubject();
            if (subject == null) {
                throw new TurnException("Subject is null");
            }
            this.credentialGenerator.setCredentialsTTL(this.ttl);
            TurnRestCredentials credentials = this.credentialGenerator.generate(subject);
            username = credentials.getUsername();
            password = credentials.getPassword();
            LOGGER.info(String.format("%s Generated username: %s", session, username));
        }
        String response = TurnRestJSONResponse.createResponse(username, password, this.ttl, this.urls);
        if (password != null) {
            Arrays.fill(password, '0');
        }
        IoBufferAllocatorEx allocator = session.getBufferAllocator();
        IoBufferEx out = allocator.wrap(allocator.allocate(response.length())).setAutoExpander(allocator);
        out.put(response.getBytes());
        out.flip();
        session.setWriteHeader("Content-Length", Integer.toString(out.remaining()));
        session.setWriteHeader("Max-Age", this.ttl);
        session.write((Object)out);
        session.close(false);
    }
}

