/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.turn.rest;

import java.security.Key;
import java.time.Instant;
import javax.security.auth.Subject;
import org.kaazing.gateway.service.turn.rest.TurnRestCredentials;
import org.kaazing.gateway.service.turn.rest.TurnRestCredentialsGenerator;
import org.kaazing.gateway.util.turn.TurnUtils;

public class DefaultCredentialsGenerator
implements TurnRestCredentialsGenerator {
    private long ttl;
    private Key sharedSecret;
    private char separator;
    private String algorithm;

    @Override
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public void setCredentialsTTL(String ttl) {
        this.ttl = Long.valueOf(ttl);
    }

    @Override
    public void setSharedSecret(Key sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    @Override
    public void setUsernameSeparator(char separator) {
        this.separator = separator;
    }

    @Override
    public TurnRestCredentials generate(Subject subject) {
        long unixTime = Instant.now().getEpochSecond() + this.ttl;
        String username = unixTime + Character.toString(this.separator) + subject.getPrincipals().iterator().next().getName();
        char[] password = TurnUtils.generatePassword((String)username, (Key)this.sharedSecret, (String)this.algorithm);
        return new TurnRestCredentials(username, password);
    }
}

