/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.turn.rest.internal;

import java.security.Key;
import java.security.KeyStore;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.naming.ConfigurationException;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.security.SecurityContext;
import org.kaazing.gateway.service.Service;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.ServiceProperties;
import org.kaazing.gateway.service.turn.rest.TurnRestCredentialsGenerator;
import org.kaazing.gateway.service.turn.rest.internal.TurnRestServiceHandler;
import org.kaazing.gateway.util.Utils;
import org.kaazing.gateway.util.feature.EarlyAccessFeatures;
import org.kaazing.gateway.util.turn.TurnUtils;

public class TurnRestService
implements Service {
    private static final String CLASS_PREFIX = "class:";
    private static final char DEFAULT_USER_SEPARATOR = ':';
    private static final String DEFAULT_CREDENTIALS_TTL = "86400";
    private static final String DEFAULT_KEY_ALGORITHM = "HmacSHA1";
    private TurnRestServiceHandler handler;
    private ServiceContext serviceContext;
    private SecurityContext securityContext;
    private Properties configuration;

    @Resource(name="securityContext")
    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public String getType() {
        return "turn.rest";
    }

    public void init(ServiceContext serviceContext) throws Exception {
        this.serviceContext = serviceContext;
        EarlyAccessFeatures.TURN_REST_SERVICE.assertEnabled(this.getConfiguration(), serviceContext.getLogger());
        ServiceProperties properties = serviceContext.getProperties();
        String urls = this.getTurnURLs(properties);
        TurnRestCredentialsGenerator credentialGeneratorInstance = this.setUpCredentialsGenerator(properties);
        String ttl = properties.get("credentials.ttl") != null ? properties.get("credentials.ttl") : DEFAULT_CREDENTIALS_TTL;
        this.handler = new TurnRestServiceHandler(Long.toString(Utils.parseTimeInterval((String)ttl, (TimeUnit)TimeUnit.SECONDS, (long)0L)), credentialGeneratorInstance, urls);
    }

    private TurnRestCredentialsGenerator setUpCredentialsGenerator(ServiceProperties properties) throws ConfigurationException, InstantiationException, IllegalAccessException {
        TurnRestCredentialsGenerator credentialGeneratorInstance = this.resolveCredentialsGenerator(properties);
        Key sharedSecret = this.resolveSharedSecret(properties);
        String algorithm = properties.get("key.algorithm") != null ? properties.get("key.algorithm") : DEFAULT_KEY_ALGORITHM;
        char separator = properties.get("username.separator") != null ? (char)properties.get("username.separator").charAt(0) : (char)':';
        credentialGeneratorInstance.setAlgorithm(algorithm);
        credentialGeneratorInstance.setSharedSecret(sharedSecret);
        credentialGeneratorInstance.setUsernameSeparator(separator);
        return credentialGeneratorInstance;
    }

    private String getTurnURLs(ServiceProperties properties) {
        StringBuilder u = new StringBuilder();
        for (String url : properties.get("url").split(",")) {
            u.append("\"").append(url).append("\",");
        }
        u.setLength(u.length() - 1);
        return u.toString();
    }

    private Key resolveSharedSecret(ServiceProperties properties) {
        KeyStore ks = this.securityContext.getKeyStore();
        String alias = properties.get("key.alias");
        return TurnUtils.getSharedSecret((KeyStore)ks, (String)alias, (char[])this.securityContext.getKeyStorePassword());
    }

    private TurnRestCredentialsGenerator resolveCredentialsGenerator(ServiceProperties properties) throws ConfigurationException, InstantiationException, IllegalAccessException {
        TurnRestCredentialsGenerator credentialGeneratorInstance;
        String credentialGeneratorClassName = properties.get("credentials.generator");
        if (credentialGeneratorClassName == null) {
            throw new ConfigurationException("No credential generator specified");
        }
        if (!credentialGeneratorClassName.startsWith(CLASS_PREFIX)) {
            throw new IllegalArgumentException("Class name must have \"class:\" prefix.");
        }
        String className = credentialGeneratorClassName.substring(CLASS_PREFIX.length());
        try {
            Class<?> clazz = Class.forName(className);
            if (!TurnRestCredentialsGenerator.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Invalid credential generator class: " + className);
            }
            Class<?> credentialGeneratorClass = clazz;
            credentialGeneratorInstance = (TurnRestCredentialsGenerator)credentialGeneratorClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unknown credential generator class: " + className, e);
        }
        return credentialGeneratorInstance;
    }

    public void start() throws Exception {
        this.serviceContext.bind(this.serviceContext.getAccepts(), (IoHandler)this.handler);
    }

    public void stop() throws Exception {
        this.quiesce();
        if (this.serviceContext != null) {
            for (IoSession session : this.serviceContext.getActiveSessions()) {
                session.close(true);
            }
        }
    }

    public void quiesce() throws Exception {
        if (this.serviceContext != null) {
            this.serviceContext.unbind(this.serviceContext.getAccepts(), (IoHandler)this.handler);
        }
    }

    public void destroy() throws Exception {
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    @Resource(name="configuration")
    public void setConfiguration(Properties configuration) {
        this.configuration = configuration;
    }
}

