/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.turn.rest.internal;

import java.util.Arrays;
import javax.security.auth.Subject;
import org.kaazing.gateway.service.turn.rest.TurnRestCredentials;
import org.kaazing.gateway.service.turn.rest.TurnRestCredentialsGenerator;
import org.kaazing.gateway.service.turn.rest.internal.TurnRestJSONResponse;
import org.kaazing.gateway.transport.IoHandlerAdapter;
import org.kaazing.gateway.transport.http.HttpAcceptSession;
import org.kaazing.gateway.transport.http.HttpMethod;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;

class TurnRestServiceHandler
extends IoHandlerAdapter<HttpAcceptSession> {
    private TurnRestCredentialsGenerator credentialGenerator;
    private String uris;
    private String ttl;

    TurnRestServiceHandler(String ttl, TurnRestCredentialsGenerator credentialGenerator, String uris) {
        this.ttl = ttl;
        this.credentialGenerator = credentialGenerator;
        this.uris = uris;
    }

    protected void doSessionOpened(HttpAcceptSession session) throws Exception {
        HttpMethod method = session.getMethod();
        String service = session.getParameter("service");
        if (method != HttpMethod.GET) {
            session.setStatus(HttpStatus.CLIENT_METHOD_NOT_ALLOWED);
            session.close(false);
            throw new IllegalArgumentException("HTTP method not allowed: " + method);
        }
        if (!"turn".equals(service)) {
            session.setStatus(HttpStatus.CLIENT_BAD_REQUEST);
            session.close(false);
            throw new IllegalArgumentException("Unsupported/invalid service: " + service);
        }
        session.setVersion(HttpVersion.HTTP_1_1);
        session.setWriteHeader("Content-Type", "application/json");
        String ttl = null == this.ttl ? session.getParameter("Max-Age") : this.ttl;
        String username = null;
        char[] password = null;
        if (this.credentialGenerator != null) {
            Subject subject = session.getSubject();
            this.credentialGenerator.setCredentialsTTL(ttl);
            TurnRestCredentials credentials = this.credentialGenerator.generate(subject);
            username = credentials.getUsername();
            password = credentials.getPassword();
        }
        String response = TurnRestJSONResponse.createResponse(username, password, ttl, this.uris);
        if (password != null) {
            Arrays.fill(password, '0');
        }
        IoBufferAllocatorEx allocator = session.getBufferAllocator();
        IoBufferEx out = allocator.wrap(allocator.allocate(response.length())).setAutoExpander(allocator);
        out.put(response.getBytes());
        out.flip();
        session.setWriteHeader("Content-Length", Integer.toString(out.remaining()));
        session.setWriteHeader("Max-Age", ttl);
        session.write((Object)out);
        session.close(false);
    }
}

