/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.http.proxy;

import java.util.Collection;
import java.util.Properties;
import javax.annotation.Resource;
import org.kaazing.gateway.resource.address.uri.URIUtils;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.http.proxy.HttpProxyServiceHandler;
import org.kaazing.gateway.service.proxy.AbstractProxyService;
import org.kaazing.gateway.util.feature.EarlyAccessFeatures;

public class HttpProxyService
extends AbstractProxyService<HttpProxyServiceHandler> {
    private static final String TRAILING_SLASH_ERROR = "The accept URI is '%s' and the connect URI is '%s'. One has a trailing slash and one doesn't. Both URIs either need to include a trailing slash or omit it.";
    private Properties configuration;

    public String getType() {
        return "http.proxy";
    }

    public void init(ServiceContext serviceContext) throws Exception {
        EarlyAccessFeatures.HTTP_PROXY_SERVICE.assertEnabled(this.configuration, serviceContext.getLogger());
        super.init(serviceContext);
        Collection connectURIs = serviceContext.getConnects();
        if (connectURIs == null || connectURIs.isEmpty()) {
            throw new IllegalArgumentException("Missing required element: <connect>");
        }
        this.checkForTrailingSlashes(serviceContext);
        HttpProxyServiceHandler handler = (HttpProxyServiceHandler)this.getHandler();
        handler.setConnectURIs(connectURIs);
        handler.init();
    }

    @Resource(name="configuration")
    public void setConfiguration(Properties configuration) {
        this.configuration = configuration;
    }

    private void checkForTrailingSlashes(ServiceContext serviceContext) {
        Collection acceptURIs = serviceContext.getAccepts();
        Collection connectURIs = serviceContext.getConnects();
        assert (acceptURIs.size() == 1);
        assert (connectURIs.size() == 1);
        String acceptURI = (String)acceptURIs.iterator().next();
        String connectURI = (String)connectURIs.iterator().next();
        String acceptPath = URIUtils.getPath((String)acceptURI);
        String connectPath = URIUtils.getPath((String)connectURI);
        boolean acceptPathIsSlash = acceptPath.endsWith("/");
        boolean connectPathIsSlash = connectPath.endsWith("/");
        if (!acceptPathIsSlash) {
            String msg = String.format("The path %s of accept URI %s for service %s needs to end with /", acceptPath, acceptURI, serviceContext.getServiceName());
            throw new IllegalArgumentException(msg);
        }
        if (!connectPathIsSlash) {
            String msg = String.format("The path %s of connect URI %s for service %s needs to end with /", connectPath, connectURI, serviceContext.getServiceName());
            throw new IllegalArgumentException(msg);
        }
    }

    protected HttpProxyServiceHandler createHandler() {
        return new HttpProxyServiceHandler();
    }
}

