/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.http.proxy;

import java.util.Collection;
import org.kaazing.gateway.resource.address.uri.URIUtils;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.http.proxy.HttpProxyServiceHandler;
import org.kaazing.gateway.service.proxy.AbstractProxyService;

public class HttpProxyService
extends AbstractProxyService<HttpProxyServiceHandler> {
    private static final String TRAILING_SLASH_ERROR = "Accept URI is '%s' and connect URI is '%s'. Either both URI should end with / or both not.";

    public String getType() {
        return "http.proxy";
    }

    public void init(ServiceContext serviceContext) throws Exception {
        super.init(serviceContext);
        Collection connectURIs = serviceContext.getConnects();
        if (connectURIs == null || connectURIs.isEmpty()) {
            throw new IllegalArgumentException("Missing required element: <connect>");
        }
        this.checkForTrailingSlashes(serviceContext);
        HttpProxyServiceHandler handler = (HttpProxyServiceHandler)this.getHandler();
        handler.setConnectURIs(connectURIs);
        handler.init();
    }

    private void checkForTrailingSlashes(ServiceContext serviceContext) {
        boolean connectPathIsSlash;
        Collection acceptURIs = serviceContext.getAccepts();
        Collection connectURIs = serviceContext.getConnects();
        assert (acceptURIs.size() == 1);
        assert (connectURIs.size() == 1);
        String acceptURI = (String)acceptURIs.iterator().next();
        String connectURI = (String)connectURIs.iterator().next();
        String acceptPath = URIUtils.getPath((String)acceptURI);
        String connectPath = URIUtils.getPath((String)connectURI);
        boolean acceptPathIsSlash = acceptPath.endsWith("/");
        if (acceptPathIsSlash ^ (connectPathIsSlash = connectPath.endsWith("/"))) {
            throw new IllegalArgumentException(String.format(TRAILING_SLASH_ERROR, acceptURI, connectURI));
        }
    }

    protected HttpProxyServiceHandler createHandler() {
        return new HttpProxyServiceHandler();
    }
}

