/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.http.proxy;

import java.net.URI;
import java.util.Collection;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.http.proxy.HttpProxyServiceHandler;
import org.kaazing.gateway.service.proxy.AbstractProxyService;

public class HttpProxyService
extends AbstractProxyService<HttpProxyServiceHandler> {
    private static final String TRAILING_SLASH_ERROR = "Accept URI is '%s' and connect URI is '%s'. Either both URI should end with / or not.";

    public String getType() {
        return "http.proxy";
    }

    public void init(ServiceContext serviceContext) throws Exception {
        super.init(serviceContext);
        Collection connectURIs = serviceContext.getConnects();
        if (connectURIs == null || connectURIs.isEmpty()) {
            throw new IllegalArgumentException("Missing required element: <connect>");
        }
        this.checkForTrailingSlashes(serviceContext);
        HttpProxyServiceHandler handler = (HttpProxyServiceHandler)this.getHandler();
        handler.setConnectURIs(connectURIs);
        handler.initServiceConnectManager();
    }

    private void checkForTrailingSlashes(ServiceContext serviceContext) {
        boolean connectPathIsSlash;
        Collection acceptURIs = serviceContext.getAccepts();
        Collection connectURIs = serviceContext.getConnects();
        assert (acceptURIs.size() == 1);
        assert (connectURIs.size() == 1);
        URI acceptURI = (URI)acceptURIs.iterator().next();
        URI connectURI = (URI)connectURIs.iterator().next();
        String acceptPath = acceptURI.getPath();
        String connectPath = connectURI.getPath();
        boolean acceptPathIsSlash = acceptPath.endsWith("/");
        if (acceptPathIsSlash ^ (connectPathIsSlash = connectPath.endsWith("/"))) {
            throw new IllegalArgumentException(String.format(TRAILING_SLASH_ERROR, acceptURI, connectURI));
        }
    }

    protected HttpProxyServiceHandler createHandler() {
        return new HttpProxyServiceHandler();
    }
}

