/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.http.proxy;

import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.http.proxy.HttpProxyServiceHandler;
import org.kaazing.gateway.service.proxy.AbstractProxyService;

public class HttpProxyService
extends AbstractProxyService<HttpProxyServiceHandler> {
    public String getType() {
        return "http.proxy";
    }

    public void init(ServiceContext serviceContext) throws Exception {
        super.init(serviceContext);
        Collection connectURIs = serviceContext.getConnects();
        if (connectURIs == null || connectURIs.isEmpty()) {
            throw new IllegalArgumentException("Missing required element: <connect>");
        }
        this.checkForTrailingSlashes(serviceContext);
        HttpProxyServiceHandler handler = (HttpProxyServiceHandler)this.getHandler();
        handler.setConnectURIs(connectURIs);
        handler.initServiceConnectManager();
    }

    private void checkForTrailingSlashes(ServiceContext serviceContext) {
        Collection acceptURIs = serviceContext.getAccepts();
        Collection connectURIs = serviceContext.getConnects();
        Iterator acceptIterator = acceptURIs.iterator();
        Iterator connectIterator = connectURIs.iterator();
        while (acceptIterator.hasNext() && connectIterator.hasNext()) {
            boolean connectPathEndsInSlash;
            String acceptPath = ((URI)acceptIterator.next()).getPath();
            String connectPath = ((URI)connectIterator.next()).getPath();
            boolean acceptPathEndsInSlash = acceptPath.endsWith("/");
            if (acceptPathEndsInSlash == (connectPathEndsInSlash = connectPath.endsWith("/"))) continue;
            throw new IllegalArgumentException("Please fix the gateway configuration file for service '" + serviceContext.getServiceName() + "'. Accept and connect must both either have trailing slashes," + " or both must not end in slashes.");
        }
    }

    protected HttpProxyServiceHandler createHandler() {
        return new HttpProxyServiceHandler();
    }
}

