/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.http.directory.cachecontrol;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.kaazing.gateway.service.http.directory.cachecontrol.Directive;
import org.kaazing.gateway.util.Utils;

public final class PatternCacheControl {
    private static final String EMPTY_STRING_VALUE = "";
    private static final String M_PLUS_STRING = "m+";
    private boolean defaultMaxAge;
    private String pattern;
    private int matchingPatternCount;
    private Map<Directive, String> directives = new HashMap<Directive, String>();

    public PatternCacheControl(String pattern, String directives) {
        this.pattern = pattern;
        this.setDirectiveList(directives);
    }

    public PatternCacheControl(String pattern, Directive directive, String value) {
        this.pattern = pattern;
        this.defaultMaxAge = true;
        this.directives.put(directive, value);
    }

    public String getPattern() {
        return this.pattern;
    }

    public Map<Directive, String> getDirectives() {
        return this.directives;
    }

    public int getMatchingPatternCount() {
        return this.defaultMaxAge ? Integer.MAX_VALUE : this.matchingPatternCount;
    }

    public void setDirective(Directive directive, String value) {
        this.directives.put(directive, value);
    }

    public String getDirectiveValue(Directive name) {
        return this.directives.get((Object)name);
    }

    public boolean hasDirective(Directive name) {
        return this.directives.get((Object)name) != null;
    }

    public void incrementMatchingPatternCount() {
        ++this.matchingPatternCount;
    }

    private void setDirectiveList(String directives) {
        String[] directiveList;
        for (String entry : directiveList = directives.replaceAll("\\s", EMPTY_STRING_VALUE).split(",")) {
            String[] nameValueArray = entry.split("=");
            String directiveName = nameValueArray[0];
            if (!this.checkDirective(directiveName)) continue;
            if (nameValueArray.length > 1) {
                this.parseDirectiveWithValue(directiveName, nameValueArray[1]);
                continue;
            }
            this.directives.put(Directive.get(directiveName), EMPTY_STRING_VALUE);
        }
    }

    private void parseDirectiveWithValue(String directiveName, String directiveValue) {
        Directive directive;
        if (directiveName.equals(Directive.MAX_AGE.getName())) {
            if (directiveValue.startsWith(M_PLUS_STRING)) {
                directiveValue = directiveValue.replace(M_PLUS_STRING, EMPTY_STRING_VALUE);
                directive = Directive.MAX_AGE_MPLUS;
            } else {
                directive = Directive.MAX_AGE;
            }
        } else {
            directive = Directive.get(directiveName);
        }
        long value = Utils.parseTimeInterval((String)directiveValue, (TimeUnit)TimeUnit.SECONDS, (long)0L);
        this.directives.put(directive, Long.toString(value));
    }

    private boolean checkDirective(String directive) {
        if (this.directives.containsKey(directive)) {
            throw new IllegalArgumentException("Duplicate cache-control directive in configuration file");
        }
        if (Directive.get(directive) == null) {
            throw new IllegalArgumentException("Missing or incorrect cache-control syntax in the configuration file");
        }
        return true;
    }
}

